/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessageRedeliveredException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transformer.simple.ByteArrayToHexString;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.util.store.AbstractMonitoredObjectStore;
import org.mule.util.store.InMemoryObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private AbstractMonitoredObjectStore<AtomicInteger> store;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            try {
                MessageDigest.getInstance(this.messageDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Exception '%s' initializing message digest algorithm %s", e.getMessage(), this.messageDigestAlgorithm)), (Initialisable)this);
            }
        }
        this.store = this.createStore();
    }

    private AbstractMonitoredObjectStore<AtomicInteger> createStore() throws InitialisationException {
        InMemoryObjectStore<AtomicInteger> s = new InMemoryObjectStore<AtomicInteger>();
        s.setName(this.flowConstruct.getName() + "." + this.getClass().getName());
        s.setMaxEntries(-1);
        s.setEntryTTL(300000);
        s.setExpirationInterval(6000);
        s.initialise();
        return s;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.store != null) {
            this.store.dispose();
            this.store = null;
        }
        if (this.deadLetterQueue instanceof Disposable) {
            ((Disposable)((Object)this.deadLetterQueue)).dispose();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.deadLetterQueue instanceof Startable) {
            ((Startable)((Object)this.deadLetterQueue)).start();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        boolean exceptionSeen = false;
        boolean tooMany = false;
        AtomicInteger counter = null;
        String messageId = null;
        try {
            messageId = this.getIdForEvent(event);
        }
        catch (Exception ex) {
            exceptionSeen = true;
        }
        if (!exceptionSeen) {
            counter = this.getCounter(messageId, null, false);
            boolean bl = tooMany = counter != null && counter.get() > this.maxRedeliveryCount;
        }
        if (tooMany || exceptionSeen) {
            try {
                if (this.deadLetterQueue != null) {
                    return this.deadLetterQueue.process(event);
                }
                throw new MessageRedeliveredException(messageId, counter.get(), this.maxRedeliveryCount, null, event);
            }
            catch (MessageRedeliveredException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.logger.info("Exception thrown from failed message processing for message " + messageId, (Throwable)ex);
                return null;
            }
        }
        try {
            MuleEvent returnEvent = this.processNext(event);
            counter = this.getCounter(messageId, counter, false);
            if (counter != null) {
                counter.set(0);
            }
            return returnEvent;
        }
        catch (MuleException ex) {
            this.incrementCounter(messageId, counter);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.incrementCounter(messageId, counter);
            throw ex;
        }
    }

    private AtomicInteger incrementCounter(String messageId, AtomicInteger counter) throws ObjectStoreException {
        counter = this.getCounter(messageId, counter, true);
        counter.incrementAndGet();
        return counter;
    }

    private AtomicInteger getCounter(String messageId, AtomicInteger counter, boolean create) throws ObjectStoreException {
        if (counter != null) {
            return counter;
        }
        boolean counterExists = this.store.contains((Serializable)((Object)messageId));
        if (counterExists) {
            return (AtomicInteger)this.store.retrieve((Serializable)((Object)messageId));
        }
        if (create) {
            try {
                counter = new AtomicInteger();
                this.store.store((Serializable)((Object)messageId), counter);
            }
            catch (ObjectAlreadyExistsException e) {
                counter = (AtomicInteger)this.store.retrieve((Serializable)((Object)messageId));
            }
        }
        return counter;
    }

    private String getIdForEvent(MuleEvent event) throws Exception {
        if (this.useSecureHash) {
            Object payload = event.getMessage().getPayload();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            if (payload instanceof InputStream) {
                event.getMessage().setPayload(bytes);
            }
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        return event.getMuleContext().getExpressionManager().parse(this.idExpression, event, true);
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }
}

