/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

class ValidateTransactionalStateInterceptor<T>
implements ExecutionInterceptor<T> {
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;

    public ValidateTransactionalStateInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig) {
        this.next = next;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public T execute(ExecutionCallback<T> callback) throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (this.transactionConfig.getAction() == 5 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Never"));
        }
        if (this.transactionConfig.getAction() == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        return this.next.execute(callback);
    }
}

