/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.TransactionCoordination;

class ResolvePreviousTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Log logger = LogFactory.getLog(ResolvePreviousTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;

    public ResolvePreviousTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig) {
        this.next = next;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public T execute(ExecutionCallback<T> callback) throws Exception {
        byte action = this.transactionConfig.getAction();
        Transaction transactionBeforeTemplate = TransactionCoordination.getInstance().getTransaction();
        if ((action == 0 || action == 1) && transactionBeforeTemplate != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(action + ", " + "current TX: " + transactionBeforeTemplate));
            }
            this.resolveTransaction(transactionBeforeTemplate);
        }
        return this.next.execute(callback);
    }

    protected void resolveTransaction(Transaction tx) throws TransactionException {
        TransactionCoordination.getInstance().resolveTransaction();
    }
}

