/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.pool;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.config.PoolingProfile;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.pool.ObjectPool;

public class CommonsPoolObjectPool
implements ObjectPool {
    protected static final Log logger = LogFactory.getLog(CommonsPoolObjectPool.class);
    protected GenericObjectPool pool;
    protected ObjectFactory objectFactory;
    protected PoolingProfile poolingProfile;
    protected MuleContext muleContext;

    public CommonsPoolObjectPool(ObjectFactory objectFactory, PoolingProfile poolingProfile, MuleContext muleContext) {
        this.objectFactory = objectFactory;
        this.poolingProfile = poolingProfile;
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        if (this.poolingProfile != null) {
            config.maxIdle = this.poolingProfile.getMaxIdle();
            config.maxActive = this.poolingProfile.getMaxActive();
            config.maxWait = this.poolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.poolingProfile.getExhaustedAction();
        }
        this.pool = new GenericObjectPool(this.getPooledObjectFactory(), config);
        try {
            this.applyInitialisationPolicy();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected PoolableObjectFactory getPooledObjectFactory() {
        return new PoolabeObjectFactoryAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInitialisationPolicy() throws Exception {
        if (this.poolingProfile != null) {
            int t;
            int numToBorrow = 0;
            int initPolicy = this.poolingProfile.getInitialisationPolicy();
            if (initPolicy == 2) {
                numToBorrow = this.poolingProfile.getMaxActive();
            } else if (initPolicy == 1) {
                numToBorrow = 1;
            }
            ArrayList<Object> holderList = new ArrayList<Object>(numToBorrow);
            try {
                for (t = 0; t < numToBorrow; ++t) {
                    holderList.add(this.getPooledObjectFactory().makeObject());
                }
            }
            finally {
                for (t = 0; t < holderList.size(); ++t) {
                    Object obj = holderList.get(t);
                    if (obj == null) continue;
                    this.returnObject(obj);
                }
            }
        }
    }

    @Override
    public Object borrowObject() throws Exception {
        if (this.pool != null) {
            return this.pool.borrowObject();
        }
        throw new InitialisationException(MessageFactory.createStaticMessage("Object pool has not been initialized."), (Initialisable)this);
    }

    @Override
    public void returnObject(Object object) {
        if (this.pool != null) {
            try {
                this.pool.returnObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.pool = null;
            }
        }
    }

    @Override
    public void clear() {
        if (this.pool != null) {
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.pool = null;
            }
        }
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    class PoolabeObjectFactoryAdapter
    implements PoolableObjectFactory {
        PoolabeObjectFactoryAdapter() {
        }

        public void activateObject(Object obj) throws Exception {
        }

        public void destroyObject(Object obj) throws Exception {
            if (obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }

        public Object makeObject() throws Exception {
            return CommonsPoolObjectPool.this.objectFactory.getInstance(CommonsPoolObjectPool.this.muleContext);
        }

        public void passivateObject(Object obj) throws Exception {
        }

        public boolean validateObject(Object obj) {
            return true;
        }
    }
}

