/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;
import org.mule.util.compression.CompressionStrategy;

public final class CompressionHelper {
    private static Log logger = LogFactory.getLog(CompressionHelper.class);
    private static CompressionStrategy defaultStrategy;

    private CompressionHelper() {
    }

    public static synchronized CompressionStrategy getDefaultCompressionStrategy() {
        if (defaultStrategy == null) {
            defaultStrategy = AccessController.doPrivileged(new PrivilegedAction<CompressionStrategy>(){

                @Override
                public CompressionStrategy run() {
                    try {
                        Object o = ClassUtils.loadClass("org.mule.util.compression.GZipCompression", CompressionHelper.class).newInstance();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found CompressionStrategy: " + o.getClass().getName()));
                        }
                        return (CompressionStrategy)o;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to build compression strategy: " + e.getMessage()));
                        return null;
                    }
                }
            });
        }
        return defaultStrategy;
    }
}

