/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

public class TransactionTemplate<T> {
    private static final Log logger = LogFactory.getLog(TransactionTemplate.class);
    private final TransactionConfig config;
    private final MuleContext context;
    private TransactionInterceptor<T> transactionInterceptor;

    TransactionTemplate(MuleContext context, TransactionConfig config) {
        this.config = config;
        this.context = context;
    }

    @Deprecated
    public TransactionTemplate(TransactionConfig config, MuleContext context) {
        this(config, context, false);
    }

    @Deprecated
    public TransactionTemplate(TransactionConfig config, MuleContext context, boolean manageExceptions) {
        this.config = config;
        this.context = context;
        this.transactionInterceptor = new ExecuteCallbackInterceptor();
        if (manageExceptions) {
            this.transactionInterceptor = new HandleExceptionInterceptor(this.transactionInterceptor);
        }
        if (config != null && config.getAction() != 6) {
            this.transactionInterceptor = new ExternalTransactionInterceptor(new ValidateTransactionalStateInterceptor(new SuspendXaTransactionInterceptor(new ResolveTransactionInterceptor(new BeginTransactionInterceptor(this.transactionInterceptor)))));
        }
    }

    TransactionTemplate(MuleContext muleContext) {
        this.context = muleContext;
        this.config = null;
    }

    void setTransactionInterceptor(TransactionInterceptor<T> transactionInterceptor) {
        this.transactionInterceptor = transactionInterceptor;
    }

    public T execute(TransactionCallback<T> callback) throws Exception {
        return this.transactionInterceptor.execute(callback);
    }

    protected void resolveTransaction(Transaction tx) throws TransactionException {
        TransactionCoordination.getInstance().resolveTransaction();
    }

    protected void suspendXATransaction(Transaction tx) throws TransactionException {
        TransactionCoordination.getInstance().suspendCurrentTransaction();
    }

    protected void resumeXATransaction(Transaction tx) throws TransactionException {
        TransactionCoordination.getInstance().resumeSuspendedTransaction();
    }

    public static interface TransactionInterceptor<T> {
        public T execute(TransactionCallback<T> var1) throws Exception;
    }

    public class ExecuteCallbackInterceptor
    implements TransactionInterceptor<T> {
        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            return callback.doInTransaction();
        }
    }

    public class BeginTransactionInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public BeginTransactionInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            byte action = TransactionTemplate.this.config.getAction();
            boolean transactionStarted = false;
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (action == 1 || action == 2 && tx == null) {
                logger.debug((Object)"Beginning transaction");
                tx = TransactionTemplate.this.config.getFactory().beginTransaction(TransactionTemplate.this.context);
                transactionStarted = true;
                logger.debug((Object)("Transaction successfully started: " + tx));
            }
            Object result = this.next.execute(callback);
            Transaction transaction = TransactionCoordination.getInstance().getTransaction();
            if (transactionStarted && transaction != null) {
                TransactionTemplate.this.resolveTransaction(transaction);
            }
            return result;
        }
    }

    public class ResolveTransactionInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public ResolveTransactionInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            byte action = TransactionTemplate.this.config.getAction();
            Transaction transactionBeforeTemplate = TransactionCoordination.getInstance().getTransaction();
            if ((action == 0 || action == 1) && transactionBeforeTemplate != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(action + ", " + "current TX: " + transactionBeforeTemplate));
                }
                TransactionTemplate.this.resolveTransaction(transactionBeforeTemplate);
            }
            Object result = this.next.execute(callback);
            Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
            if (currentTransaction != null && (TransactionTemplate.this.config.getAction() == 1 || TransactionTemplate.this.config.getAction() == 2 && transactionBeforeTemplate == null)) {
                TransactionTemplate.this.resolveTransaction(currentTransaction);
            }
            return result;
        }
    }

    public class ValidateTransactionalStateInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public ValidateTransactionalStateInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            if (TransactionTemplate.this.config.getAction() == 5 && tx != null) {
                throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Never"));
            }
            if (TransactionTemplate.this.config.getAction() == 3 && tx == null) {
                throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
            }
            return this.next.execute(callback);
        }
    }

    public class SuspendXaTransactionInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public SuspendXaTransactionInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            Transaction suspendedXATx = null;
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            byte action = TransactionTemplate.this.config.getAction();
            if ((action == 0 || action == 1) && tx != null && tx.isXA()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("suspending XA tx " + action + ", " + "current TX: " + tx));
                }
                suspendedXATx = tx;
                TransactionTemplate.this.suspendXATransaction(suspendedXATx);
            }
            Object result = this.next.execute(callback);
            if (suspendedXATx != null) {
                TransactionTemplate.this.resumeXATransaction(suspendedXATx);
            }
            return result;
        }
    }

    public class ExternalTransactionInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public ExternalTransactionInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            Transaction joinedExternal = null;
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            try {
                TransactionFactory tmFactory;
                if (tx == null && TransactionTemplate.this.context != null && TransactionTemplate.this.config != null && TransactionTemplate.this.config.isInteractWithExternal() && (tmFactory = TransactionTemplate.this.config.getFactory()) instanceof ExternalTransactionAwareTransactionFactory) {
                    ExternalTransactionAwareTransactionFactory externalTransactionFactory = (ExternalTransactionAwareTransactionFactory)tmFactory;
                    joinedExternal = tx = externalTransactionFactory.joinExternalTransaction(TransactionTemplate.this.context);
                }
                Object t = this.next.execute(callback);
                return t;
            }
            finally {
                if (joinedExternal != null) {
                    TransactionCoordination.getInstance().unbindTransaction(joinedExternal);
                }
            }
        }
    }

    public class HandleExceptionInterceptor
    implements TransactionInterceptor<T> {
        public TransactionInterceptor<T> next;

        public HandleExceptionInterceptor(TransactionInterceptor next) {
            this.next = next;
        }

        @Override
        public T execute(TransactionCallback<T> callback) throws Exception {
            try {
                return this.next.execute(callback);
            }
            catch (MessagingException e) {
                MuleEvent result = e.getEvent().getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
                e.setProcessedEvent(result);
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
    }
}

