/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transaction.TransactionConfig;
import org.mule.config.i18n.CoreMessages;
import org.mule.process.ProcessingCallback;
import org.mule.process.TransactionalProcessingTemplate;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected TransactionConfig transactionConfig;

    public TransactionalInterceptingMessageProcessor(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        TransactionalProcessingTemplate<MuleEvent> processingTemplate = new TransactionalProcessingTemplate<MuleEvent>(this.muleContext, this.transactionConfig);
        ProcessingCallback<MuleEvent> processingCallback = new ProcessingCallback<MuleEvent>(){

            @Override
            public MuleEvent process() throws Exception {
                return TransactionalInterceptingMessageProcessor.this.processNext(event);
            }
        };
        try {
            return processingTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), (Throwable)e);
        }
    }
}

