/*
 * Decompiled with CFR 0.152.
 */
package org.mule.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.process.ProcessingCallback;
import org.mule.process.ProcessingInterceptor;
import org.mule.transaction.TransactionCoordination;

class ResolvePreviousTransactionInterceptor<T>
implements ProcessingInterceptor<T> {
    private static final Log logger = LogFactory.getLog(ResolvePreviousTransactionInterceptor.class);
    private final ProcessingInterceptor<T> next;
    private TransactionConfig transactionConfig;

    public ResolvePreviousTransactionInterceptor(ProcessingInterceptor<T> next, TransactionConfig transactionConfig) {
        this.next = next;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public T execute(ProcessingCallback<T> callback) throws Exception {
        byte action = this.transactionConfig.getAction();
        Transaction transactionBeforeTemplate = TransactionCoordination.getInstance().getTransaction();
        if ((action == 0 || action == 1) && transactionBeforeTemplate != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(action + ", " + "current TX: " + transactionBeforeTemplate));
            }
            this.resolveTransaction(transactionBeforeTemplate);
        }
        return this.next.execute(callback);
    }

    protected void resolveTransaction(Transaction tx) throws TransactionException {
        TransactionCoordination.getInstance().resolveTransaction();
    }
}

