/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.counters.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.util.counters.Counter;
import org.mule.util.counters.CounterFactory;
import org.mule.util.counters.impl.AggregateCounter;

public abstract class AbstractCounter
implements Counter {
    private final CounterFactory.Type type;
    private final String name;
    private final List aggregates;

    public AbstractCounter(String name, CounterFactory.Type type) {
        this.name = name;
        this.type = type;
        this.aggregates = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public CounterFactory.Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract double increment();

    @Override
    public abstract double incrementBy(double var1);

    @Override
    public abstract double decrement();

    @Override
    public abstract void setRawValue(double var1);

    @Override
    public abstract double nextValue();

    protected void addAggregate(AggregateCounter counter) {
        this.aggregates.add(counter);
    }

    protected void propagate() {
        for (AggregateCounter agg : this.aggregates) {
            agg.compute();
        }
    }
}

