/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.transport.AbstractPollingMessageReceiver;

public class PollingReceiverWorker
implements Work {
    protected final AbstractPollingMessageReceiver receiver;
    protected volatile boolean running = false;

    public PollingReceiverWorker(AbstractPollingMessageReceiver pollingMessageReceiver) {
        this.receiver = pollingMessageReceiver;
    }

    public AbstractPollingMessageReceiver getReceiver() {
        return this.receiver;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RequestContext.clear();
        if (this.receiver.isStarted()) {
            this.running = true;
            try {
                this.poll();
            }
            catch (InterruptedException e) {
                try {
                    this.receiver.stop();
                }
                catch (MuleException e1) {
                    this.receiver.getConnector().getMuleContext().getExceptionListener().handleException(e1);
                }
            }
            catch (MessagingException e) {
                MuleEvent event = e.getEvent();
                event.getFlowConstruct().getExceptionListener().handleException(e, event);
            }
            catch (Exception e) {
                this.receiver.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
            finally {
                this.running = false;
            }
        }
    }

    protected void poll() throws Exception {
        this.receiver.performPoll();
    }

    public void release() {
    }
}

