/*
 * Decompiled with CFR 0.152.
 */
package org.mule.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ObjectUtils;

public class StartableCompositeMessageSource
implements CompositeMessageSource,
Lifecycle,
FlowConstructAware {
    protected static final Log log = LogFactory.getLog(StartableCompositeMessageSource.class);
    protected MessageProcessor listener;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected final List<MessageSource> sources = Collections.synchronizedList(new ArrayList());
    protected AtomicBoolean starting = new AtomicBoolean(false);
    protected FlowConstruct flowConstruct;
    private final MessageProcessor internalListener = new InternalMessageProcessor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSource(MessageSource source) throws MuleException {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.sources.add(source);
        }
        source.setListener(this.internalListener);
        if (this.initialised.get()) {
            if (source instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)source)).setFlowConstruct(this.flowConstruct);
            }
            if (source instanceof Initialisable) {
                ((Initialisable)((Object)source)).initialise();
            }
        }
        if (this.started.get() && source instanceof Startable) {
            ((Startable)((Object)source)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSource(MessageSource source) throws MuleException {
        if (this.started.get()) {
            if (source instanceof Stoppable) {
                ((Stoppable)((Object)source)).stop();
            }
            if (source instanceof Disposable) {
                ((Disposable)((Object)source)).dispose();
            }
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.sources.remove(source);
        }
    }

    public void setMessageSources(List<MessageSource> sources) throws MuleException {
        this.sources.clear();
        for (MessageSource messageSource : sources) {
            this.addSource(messageSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        if (this.listener == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("listener"), (Initialisable)this);
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (source instanceof FlowConstructAware) {
                    ((FlowConstructAware)((Object)source)).setFlowConstruct(this.flowConstruct);
                }
                if (!(source instanceof Initialisable)) continue;
                ((Initialisable)((Object)source)).initialise();
            }
        }
        this.initialised.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        if (this.listener == null) {
            throw new LifecycleException(CoreMessages.objectIsNull("listener"), (Object)this);
        }
        List<MessageSource> list = this.sources;
        synchronized (list) {
            this.starting.set(true);
            for (MessageSource source : this.sources) {
                if (!(source instanceof Startable)) continue;
                ((Startable)((Object)source)).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (!(source instanceof Stoppable)) continue;
                ((Stoppable)((Object)source)).stop();
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageSource> list = this.sources;
        synchronized (list) {
            for (MessageSource source : this.sources) {
                if (!(source instanceof Disposable)) continue;
                ((Disposable)((Object)source)).dispose();
            }
        }
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.listener = listener;
    }

    @Override
    public void setFlowConstruct(FlowConstruct pattern) {
        this.flowConstruct = pattern;
    }

    @Override
    public List<MessageSource> getSources() {
        return this.sources;
    }

    public String toString() {
        return String.format("%s [listener=%s, sources=%s, started=%s]", this.getClass().getSimpleName(), this.listener, this.sources, this.started);
    }

    private class InternalMessageProcessor
    implements MessageProcessor {
        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            if (StartableCompositeMessageSource.this.started.get() || StartableCompositeMessageSource.this.starting.get()) {
                return StartableCompositeMessageSource.this.listener.process(event);
            }
            throw new IllegalStateException(String.format("A message was receieved from MessageSource, but CompositeMessageSource is stopped.%n  Message: %s%n  CompositeMessageSource: %s", event, this));
        }

        public String toString() {
            return ObjectUtils.toString(this);
        }
    }
}

