/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.construct.Pipeline;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    protected MessageSource messageSource;
    protected MessageProcessor pipeline;
    protected List<MessageProcessor> messageProcessors = Collections.emptyList();
    protected ProcessingStrategy processingStrategy = new SynchronousProcessingStrategy();

    public AbstractPipeline(String name, MuleContext muleContext) {
        super(name, muleContext);
    }

    protected MessageProcessor createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this);
        builder.setName("'" + this.getName() + "' processor chain");
        this.configurePreProcessors(builder);
        this.configureMessageProcessors(builder);
        this.configurePostProcessors(builder);
        return builder.build();
    }

    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
    }

    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
    }

    @Override
    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    public void setProcessingStrategy(ProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.messageSource != null) {
            this.messageSource.setListener(new AbstractInterceptingMessageProcessor(){

                @Override
                public MuleEvent process(MuleEvent event) throws MuleException {
                    return AbstractPipeline.this.pipeline.process(event);
                }
            });
        }
        this.injectFlowConstructMuleContext(this.messageSource);
        this.injectFlowConstructMuleContext(this.pipeline);
        this.initialiseIfInitialisable(this.messageSource);
        this.initialiseIfInitialisable(this.pipeline);
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return AbstractPipeline.this.getName();
            }
        }, builder, this.muleContext);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        boolean userConfiguredAsyncProcessingStrategy;
        super.validateConstruct();
        boolean bl = userConfiguredAsyncProcessingStrategy = this.processingStrategy instanceof AsynchronousProcessingStrategy && !(this.processingStrategy instanceof DefaultFlowProcessingStrategy);
        if (userConfiguredAsyncProcessingStrategy && !this.isMessageSourceCompatibleWithAsync(this.messageSource)) {
            throw new FlowConstructInvalidException(CoreMessages.createStaticMessage("One of the inbound endpoint configured on this Flow is not compatible with an asynchronous processing strategy.  Either because it is request-response or has a transaction defined."), this);
        }
    }

    private boolean isMessageSourceCompatibleWithAsync(MessageSource source) {
        if (source instanceof InboundEndpoint) {
            InboundEndpoint endpoint = (InboundEndpoint)source;
            return !endpoint.getExchangePattern().hasResponse() && !endpoint.getTransactionConfig().isConfigured();
        }
        if (this.messageSource instanceof CompositeMessageSource) {
            for (MessageSource childSource : ((CompositeMessageSource)source).getSources()) {
                if (this.isMessageSourceCompatibleWithAsync(childSource)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        this.startIfStartable(this.pipeline);
        this.startIfStartable(this.messageSource);
    }

    @Override
    protected void doStop() throws MuleException {
        this.stopIfStoppable(this.messageSource);
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doDispose() {
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.messageSource);
        super.doDispose();
    }
}

