/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.cache.CachingStrategy;
import org.mule.cache.filter.ConsumableMuleMessageFilter;
import org.mule.cache.keygenerator.KeyGenerator;
import org.mule.cache.keygenerator.MD5KeyGenerator;
import org.mule.cache.responsegenerator.DefaultResponseGenerator;
import org.mule.cache.responsegenerator.ResponseGenerator;
import org.mule.util.store.InMemoryObjectStore;

public class ObjectStoreCachingStrategy
implements CachingStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ObjectStore<MuleEvent> store = new InMemoryObjectStore<MuleEvent>();
    private KeyGenerator keyGenerator = new MD5KeyGenerator();
    private ResponseGenerator responseGenerator = new DefaultResponseGenerator();
    private Filter consumableFilter = new ConsumableMuleMessageFilter();
    private String name;

    @Override
    public MuleEvent process(MuleEvent request, MessageProcessor messageProcessor) throws MuleException {
        if (this.consumableFilter.accept(request.getMessage())) {
            Serializable key;
            try {
                key = this.keyGenerator.generateKey(request);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Message will be processed without cache: key generation error", (Throwable)e);
                return messageProcessor.process(request);
            }
            return this.processMessageWithCache(key, request, messageProcessor);
        }
        return messageProcessor.process(request);
    }

    private MuleEvent processMessageWithCache(Serializable key, MuleEvent request, MessageProcessor messageProcessor) throws MuleException {
        MuleEvent response;
        MuleEvent cachedResponse = this.lookupEventInCache(key);
        if (cachedResponse != null) {
            response = this.responseGenerator.create(request, cachedResponse);
        } else {
            response = messageProcessor.process(request);
            if (response == null || this.consumableFilter.accept(response.getMessage())) {
                MuleEvent responseCopy = response;
                if (response instanceof ThreadSafeAccess) {
                    responseCopy = (MuleEvent)((Object)((ThreadSafeAccess)((Object)response)).newThreadCopy());
                }
                this.store(key, responseCopy);
            }
        }
        return response;
    }

    private MuleEvent lookupEventInCache(Serializable key) {
        MuleEvent event = this.retrieve(key);
        if (this.logger.isDebugEnabled()) {
            if (event != null) {
                this.logger.debug((Object)("Cache hit for key: " + key + " Event: " + event));
            } else {
                this.logger.debug((Object)("Cache miss for key: " + key));
            }
        }
        return event;
    }

    protected void store(Serializable key, MuleEvent value) {
        try {
            this.store.store(key, value);
        }
        catch (ObjectAlreadyExistsException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("An object with the specified key already exists in the object store (" + key + ")"));
            }
        }
        catch (ObjectStoreException e) {
            this.logger.warn((Object)"Unable to store event in cache", (Throwable)e);
        }
    }

    protected MuleEvent retrieve(Serializable key) {
        try {
            return this.store.retrieve(key);
        }
        catch (ObjectDoesNotExistException e) {
        }
        catch (ObjectStoreException e) {
            this.logger.warn((Object)"Unable to retrieve object from cache", (Throwable)e);
        }
        return null;
    }

    public ObjectStore<MuleEvent> getStore() {
        return this.store;
    }

    public void setStore(ObjectStore<MuleEvent> store) {
        this.store = store;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public ResponseGenerator getResponseGenerator() {
        return this.responseGenerator;
    }

    public void setResponseGenerator(ResponseGenerator responseGenerator) {
        this.responseGenerator = responseGenerator;
    }

    public Filter getConsumableFilter() {
        return this.consumableFilter;
    }

    public void setConsumableFilter(Filter consumableFilter) {
        this.consumableFilter = consumableFilter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

