/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.OutputStream;
import java.net.URI;
import java.util.EventObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.ResponseOutputStream;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.ProcessingTime;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.security.MuleCredentials;
import org.mule.session.DefaultMuleSession;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultMuleEvent
extends EventObject
implements MuleEvent,
ThreadSafeAccess,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(DefaultMuleEvent.class);
    private final String id;
    private final MuleMessage message;
    private final MuleSession session;
    private final Credentials credentials;
    private final String encoding;
    private final MessageExchangePattern exchangePattern;
    private final URI messageSourceURI;
    private final String messageSourceName;
    private final ReplyToHandler replyToHandler;
    private final boolean transacted;
    private final boolean synchronous;
    private boolean stopFurtherProcessing = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream;
    private final ProcessingTime processingTime;
    private Object replyToDestination;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session) {
        this(message, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session, ResponseOutputStream outputStream) {
        this(message, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, ResponseOutputStream outputStream) {
        this(message, URI.create("none"), exchangePattern, session, timeout, credentials, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session) {
        this(message, messageSourceURI, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session, ResponseOutputStream outputStream) {
        this(message, messageSourceURI, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.id = this.generateEventId(message.getMuleContext());
        this.message = message;
        this.session = session;
        this.exchangePattern = exchangePattern;
        this.outputStream = outputStream;
        this.credentials = null;
        this.encoding = message.getMuleContext().getConfiguration().getDefaultEncoding();
        this.messageSourceName = messageSourceURI.toString();
        this.messageSourceURI = messageSourceURI;
        this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.replyToHandler = null;
        this.replyToDestination = null;
        this.timeout = timeout;
        this.transacted = false;
        this.synchronous = this.resolveEventSynchronicity();
    }

    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, MuleSession session) {
        this(message, endpoint, session, null, null);
    }

    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, MuleSession session, ReplyToHandler replyToHandler, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.id = this.generateEventId(message.getMuleContext());
        this.message = message;
        this.session = session;
        this.outputStream = outputStream;
        this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.replyToHandler = replyToHandler;
        this.credentials = this.extractCredentials(endpoint);
        this.encoding = endpoint.getEncoding();
        this.exchangePattern = endpoint.getExchangePattern();
        this.messageSourceName = endpoint.getName();
        this.messageSourceURI = endpoint.getEndpointURI().getUri();
        this.timeout = endpoint.getResponseTimeout();
        this.transacted = endpoint.getTransactionConfig().isTransacted();
        this.fillProperties(endpoint);
        this.synchronous = this.resolveEventSynchronicity();
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        this(message, rewriteEvent, rewriteEvent.getSession());
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus) {
        this(message, rewriteEvent, rewriteEvent.getSession(), synchronus);
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, MuleSession session) {
        this(message, rewriteEvent, session, rewriteEvent.isSynchronous());
    }

    protected DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, MuleSession session, boolean synchronous) {
        super(message.getPayload());
        this.id = rewriteEvent.getId();
        this.message = message;
        this.session = session;
        this.credentials = rewriteEvent.getCredentials();
        this.encoding = rewriteEvent.getEncoding();
        this.exchangePattern = rewriteEvent.getExchangePattern();
        this.messageSourceName = rewriteEvent.getMessageSourceName();
        this.messageSourceURI = rewriteEvent.getMessageSourceURI();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        this.processingTime = rewriteEvent instanceof DefaultMuleEvent ? ((DefaultMuleEvent)rewriteEvent).processingTime : ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.replyToHandler = rewriteEvent.getReplyToHandler();
        this.replyToDestination = rewriteEvent.getReplyToDestination();
        this.timeout = rewriteEvent.getTimeout();
        this.transacted = rewriteEvent.isTransacted();
        this.synchronous = synchronous;
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, String messageSourceName, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, ResponseOutputStream outputStream, String encoding, boolean transacted, boolean synchronous, Object replyToDestination, ReplyToHandler replyToHandler) {
        super(message.getPayload());
        this.id = this.generateEventId(message.getMuleContext());
        this.message = message;
        this.session = session;
        this.credentials = credentials;
        this.encoding = encoding;
        this.exchangePattern = exchangePattern;
        this.messageSourceURI = messageSourceURI;
        this.messageSourceName = messageSourceName;
        this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.replyToHandler = replyToHandler;
        this.transacted = transacted;
        this.synchronous = synchronous;
        this.timeout = timeout;
        this.outputStream = outputStream;
        this.replyToDestination = replyToDestination;
    }

    protected boolean resolveEventSynchronicity() {
        boolean syncProcessingStrategy = false;
        if (this.session.getFlowConstruct() != null && this.session.getFlowConstruct() instanceof Pipeline) {
            syncProcessingStrategy = ((Pipeline)this.session.getFlowConstruct()).getProcessingStrategy().getClass().equals(SynchronousProcessingStrategy.class);
        }
        return this.transacted || this.exchangePattern.hasResponse() || this.message.getProperty("MULE_FORCE_SYNC", PropertyScope.INBOUND, Boolean.FALSE) != false || syncProcessingStrategy;
    }

    protected void fillProperties(InboundEndpoint endpoint) {
        if (endpoint != null && endpoint.getProperties() != null) {
            for (String prop : endpoint.getProperties().keySet()) {
                if (this.ignoreProperty(prop)) continue;
                Object value = endpoint.getProperties().get(prop);
                this.message.setInvocationProperty(prop, value);
            }
        }
    }

    protected boolean ignoreProperty(String key) {
        if (key == null || key.startsWith("MULE_ENDPOINT__")) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getOutboundProperty(key);
    }

    protected Credentials extractCredentials(InboundEndpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointURI() && null != endpoint.getEndpointURI().getUserInfo()) {
            String userName = endpoint.getEndpointURI().getUser();
            String password = endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                return new MuleCredentials(userName, password.toCharArray());
            }
        }
        return null;
    }

    @Override
    public Credentials getCredentials() {
        MuleCredentials creds = (MuleCredentials)this.message.getOutboundProperty("MULE_CREDENTIALS");
        return this.credentials != null ? this.credentials : creds;
    }

    @Override
    public MuleMessage getMessage() {
        return this.message;
    }

    @Override
    public byte[] getMessageAsBytes() throws DefaultMuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public <T> T transformMessage(Class<T> outputType) throws TransformerException {
        return this.transformMessage(DataTypeFactory.create(outputType));
    }

    @Override
    public <T> T transformMessage(DataType<T> outputType) throws TransformerException {
        if (outputType == null) {
            throw new TransformerException(CoreMessages.objectIsNull("outputType"));
        }
        return this.message.getPayload(outputType);
    }

    @Override
    @Deprecated
    public byte[] transformMessageToBytes() throws TransformerException {
        return this.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE);
    }

    @Override
    public String transformMessageToString() throws TransformerException {
        return this.transformMessage(DataTypeFactory.createWithEncoding(String.class, this.getEncoding()));
    }

    @Override
    public String getMessageAsString() throws MuleException {
        return this.getMessageAsString(this.getEncoding());
    }

    @Override
    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadForLogging(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public Object getProperty(String name) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    @Override
    @Deprecated
    public Object getProperty(String name, Object defaultValue) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("MuleEvent: ").append(this.getId());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.messageSourceURI);
        return buf.toString();
    }

    protected String generateEventId(MuleContext context) {
        return context.getUniqueIdString();
    }

    @Override
    public MuleSession getSession() {
        return this.session;
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.session.getFlowConstruct();
    }

    @Override
    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    @Override
    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMuleEvent)) {
            return false;
        }
        DefaultMuleEvent event = (DefaultMuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    @Override
    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            return this.message.getMuleContext().getConfiguration().getDefaultResponseTimeout();
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        if (timeout >= 0) {
            this.timeout = timeout;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        if (this.session instanceof DefaultMuleSession) {
            ((DefaultMuleSession)this.session).initAfterDeserialisation(muleContext);
        }
        if (this.message instanceof DefaultMuleMessage) {
            ((DefaultMuleMessage)this.message).initAfterDeserialisation(muleContext);
        }
        if (this.replyToHandler instanceof DefaultReplyToHandler) {
            ((DefaultReplyToHandler)this.replyToHandler).initAfterDeserialisation(muleContext);
        }
        if (this.replyToDestination instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(this.replyToDestination, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        }
    }

    @Override
    public String getEncoding() {
        if (this.message.getEncoding() != null) {
            return this.message.getEncoding();
        }
        return this.encoding;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.message.getMuleContext();
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    @Override
    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    @Override
    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }

    @Override
    @Deprecated
    public Object transformMessage() throws TransformerException {
        logger.warn((Object)"Deprecation warning: MuleEvent.transformMessage does nothing in Mule 3.x.  The message is already transformed before the event reaches a component");
        return this.message.getPayload();
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    @Override
    public boolean isTransacted() {
        return this.transacted;
    }

    @Override
    public URI getMessageSourceURI() {
        return this.messageSourceURI;
    }

    @Override
    public String getMessageSourceName() {
        return this.messageSourceName;
    }

    @Override
    public ReplyToHandler getReplyToHandler() {
        return this.replyToHandler;
    }

    @Override
    public Object getReplyToDestination() {
        return this.replyToDestination;
    }

    @Override
    public void captureReplyToDestination() {
        if (this.message != null) {
            this.replyToDestination = this.message.getReplyTo();
            this.message.setReplyTo(null);
        }
    }

    @Override
    public boolean isSynchronous() {
        return this.synchronous;
    }
}

