/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.scan.ClassScanner;
import org.mule.util.scan.ImplementationClassScanner;
import org.mule.util.scan.InterfaceClassScanner;
import org.mule.util.scan.annotations.AnnotationFilter;
import org.mule.util.scan.annotations.AnnotationTypeFilter;
import org.mule.util.scan.annotations.AnnotationsScanner;
import org.mule.util.scan.annotations.ClosableClassReader;
import org.mule.util.scan.annotations.MetaAnnotationTypeFilter;

public class ClasspathScanner {
    public static final int INCLUDE_ABSTRACT = 1;
    public static final int INCLUDE_INTERFACE = 2;
    public static final int INCLUDE_INNER = 4;
    public static final int INCLUDE_ANONYMOUS = 8;
    public static final int DEFAULT_FLAGS = 0;
    protected final transient Log logger = LogFactory.getLog(ClasspathScanner.class);
    private ClassLoader classLoader;
    private String[] basepaths;

    public ClasspathScanner(String ... basepaths) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.basepaths = basepaths;
    }

    public ClasspathScanner(ClassLoader classLoader, String ... basepaths) {
        this.classLoader = classLoader;
        this.basepaths = basepaths;
    }

    public <T> Set<Class<T>> scanFor(Class<T> clazz) throws IOException {
        return this.scanFor(clazz, 0);
    }

    public <T> Set<Class<T>> scanFor(Class<T> clazz, int flags) throws IOException {
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (int i = 0; i < this.basepaths.length; ++i) {
            String basepath = this.basepaths[i];
            Enumeration<URL> urls = this.classLoader.getResources(basepath.trim());
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    classes.addAll(this.processFileUrl(url, basepath, clazz, flags));
                    continue;
                }
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    classes.addAll(this.processJarUrl(url, basepath, clazz, flags));
                    continue;
                }
                throw new IllegalArgumentException("Do not understand how to handle protocol: " + url.getProtocol());
            }
        }
        return classes;
    }

    protected <T> Set<Class<T>> processJarUrl(URL url, String basepath, Class<T> clazz, int flags) throws IOException {
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        String path = url.getFile().substring(5, url.getFile().indexOf("!"));
        path = path.replaceAll("%20", " ");
        JarFile jar = new JarFile(path);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(basepath) || !entry.getName().endsWith(".class")) continue;
            try {
                String name = entry.getName();
                if (name.contains("$") && !this.hasFlag(flags, 4)) continue;
                URL classURL = this.classLoader.getResource(name);
                InputStream classStream = classURL.openStream();
                ClosableClassReader reader = new ClosableClassReader(classStream);
                ClassScanner visitor = this.getScanner(clazz);
                reader.accept(visitor, 0);
                if (!visitor.isMatch()) continue;
                Class<?> loadedClass = this.loadClass(visitor.getClassName());
                this.addClassToSet(loadedClass, set, flags);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) continue;
                Throwable t = ExceptionHelper.getRootException(e);
                this.logger.debug((Object)String.format("%s: caused by: %s", e.toString(), t.toString()));
            }
        }
        jar.close();
        return set;
    }

    protected boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    protected <T> Set<Class<T>> processFileUrl(URL url, String basepath, Class<T> clazz, int flags) throws IOException {
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        String urlBase = url.getFile();
        File dir = new File(urlBase = urlBase.replaceAll("%20", " "));
        if (!dir.isDirectory()) {
            this.logger.warn((Object)("Cannot process File URL: " + url + ". Path is not a directory"));
            return set;
        }
        Collection files = FileUtils.listFiles((File)new File(urlBase), (String[])new String[]{"class"}, (boolean)true);
        for (File file : files) {
            try {
                if (file.getName().contains("$") && !this.hasFlag(flags, 4)) continue;
                FileInputStream classStream = new FileInputStream(file);
                ClosableClassReader reader = new ClosableClassReader(classStream);
                ClassScanner visitor = this.getScanner(clazz);
                reader.accept(visitor, 0);
                if (!visitor.isMatch()) continue;
                Class<?> loadedClass = this.loadClass(visitor.getClassName());
                this.addClassToSet(loadedClass, set, flags);
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) continue;
                Throwable t = ExceptionHelper.getRootException(e);
                this.logger.debug((Object)String.format("%s: caused by: %s", e.toString(), t.toString()));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void addClassToSet(Class<T> c, Set<Class<T>> set, int flags) {
        if (c != null) {
            Set<Class<T>> set2 = set;
            synchronized (set2) {
                if (c.isInterface()) {
                    if (this.hasFlag(flags, 2)) {
                        set.add(c);
                    }
                } else if (Modifier.isAbstract(c.getModifiers())) {
                    if (this.hasFlag(flags, 1)) {
                        set.add(c);
                    }
                } else {
                    set.add(c);
                }
            }
        }
    }

    protected Class<?> loadClass(String name) {
        String c = name.replace("/", ".");
        try {
            return ClassUtils.loadClass(c, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)String.format("%s : %s", c, e.toString()));
            }
            return null;
        }
    }

    protected ClassScanner getScanner(Class<?> clazz) {
        if (clazz.isInterface()) {
            if (clazz.isAnnotation()) {
                Class<?> annotationClass = clazz;
                AnnotationFilter filter = null;
                Annotation[] annos = clazz.getDeclaredAnnotations();
                for (int i = 0; i < annos.length; ++i) {
                    Annotation anno = annos[i];
                    if (!(anno instanceof Target) || ((Target)anno).value()[0] != ElementType.ANNOTATION_TYPE) continue;
                    filter = new MetaAnnotationTypeFilter(annotationClass, this.classLoader);
                }
                if (filter == null) {
                    filter = new AnnotationTypeFilter(annotationClass);
                }
                return new AnnotationsScanner(filter);
            }
            return new InterfaceClassScanner(clazz);
        }
        return new ImplementationClassScanner(clazz);
    }
}

