/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.QueueInfo;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.xa.AbstractTransactionContext;

public class QueueTransactionContext
extends AbstractTransactionContext {
    private final TransactionalQueueManager transactionalQueueManager;
    protected Map<QueueInfo, List<Serializable>> added;
    protected Map<QueueInfo, List<Serializable>> removed;

    public QueueTransactionContext(TransactionalQueueManager transactionalQueueManager) {
        this.transactionalQueueManager = transactionalQueueManager;
    }

    public boolean offer(QueueInfo queue, Serializable item, long offerTimeout) throws InterruptedException {
        this.readOnly = false;
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupQueue(queue);
        if (queue.offer(null, queueAdded.size(), offerTimeout)) {
            queueAdded.add(item);
            return true;
        }
        return false;
    }

    public void untake(QueueInfo queue, Serializable item) throws InterruptedException {
        this.readOnly = false;
        this.initializeAdded();
        List<Serializable> queueAdded = this.lookupQueue(queue);
        queueAdded.add(item);
    }

    public Serializable poll(QueueInfo queue, long pollTimeout) throws InterruptedException, ObjectStoreException {
        Serializable object;
        List<Serializable> queueAdded;
        this.readOnly = false;
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            return queueAdded.remove(queueAdded.size() - 1);
        }
        try {
            object = queue.poll(pollTimeout);
        }
        catch (InterruptedException e) {
            if (this.transactionalQueueManager.getMuleContext().isStopping()) {
                throw e;
            }
            return null;
        }
        if (object != null) {
            List<Serializable> queueRemoved;
            if (this.removed == null) {
                this.removed = new HashMap<QueueInfo, List<Serializable>>();
            }
            if ((queueRemoved = this.removed.get(queue)) == null) {
                queueRemoved = new ArrayList<Serializable>();
                this.removed.put(queue, queueRemoved);
            }
            queueRemoved.add(object);
            object = this.transactionalQueueManager.doLoad(queue, object);
        }
        return object;
    }

    public Serializable peek(QueueInfo queue) throws InterruptedException, ObjectStoreException {
        List<Serializable> queueAdded;
        this.readOnly = false;
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            return queueAdded.get(queueAdded.size() - 1);
        }
        Serializable o = queue.peek();
        if (o != null) {
            o = this.transactionalQueueManager.doLoad(queue, o);
        }
        return o;
    }

    public int size(QueueInfo queue) {
        List<Serializable> queueAdded;
        int sz = queue.getSize();
        if (this.added != null && (queueAdded = this.added.get(queue)) != null) {
            sz += queueAdded.size();
        }
        return sz;
    }

    protected void initializeAdded() {
        if (this.added == null) {
            this.added = new HashMap<QueueInfo, List<Serializable>>();
        }
    }

    protected List<Serializable> lookupQueue(QueueInfo queue) {
        List<Serializable> queueAdded = this.added.get(queue);
        if (queueAdded == null) {
            queueAdded = new ArrayList<Serializable>();
            this.added.put(queue, queueAdded);
        }
        return queueAdded;
    }
}

