/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.Work;
import org.apache.commons.lang.SerializationException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.SessionHandler;
import org.mule.session.LegacySessionHandler;
import org.mule.session.MuleSessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;

public abstract class AbstractReceiverWorker
implements Work {
    protected List<Object> messages;
    protected InboundEndpoint endpoint;
    protected AbstractMessageReceiver receiver;
    protected OutputStream out;

    public AbstractReceiverWorker(List<Object> messages, AbstractMessageReceiver receiver) {
        this(messages, receiver, null);
    }

    public AbstractReceiverWorker(List<Object> messages, AbstractMessageReceiver receiver, OutputStream out) {
        this.messages = messages;
        this.receiver = receiver;
        this.endpoint = receiver.getEndpoint();
        this.out = out;
    }

    public final void run() {
        this.doRun();
        this.release();
    }

    protected void doRun() {
        try {
            this.processMessages();
        }
        catch (MessagingException e) {
            this.receiver.getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
        }
        catch (Exception e) {
            this.receiver.getConnector().getMuleContext().getExceptionListener().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages() throws Exception {
        TransactionTemplate tt = new TransactionTemplate(this.endpoint.getTransactionConfig(), this.receiver.getConnector().getMuleContext());
        TransactionCallback cb = new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                Transaction tx = TransactionCoordination.getInstance().getTransaction();
                if (tx != null) {
                    AbstractReceiverWorker.this.bindTransaction(tx);
                }
                ArrayList<Object> results = new ArrayList<Object>(AbstractReceiverWorker.this.messages.size());
                for (Object payload : AbstractReceiverWorker.this.messages) {
                    MuleEvent resultEvent;
                    MuleMessage result;
                    MuleSession session;
                    if ((payload = AbstractReceiverWorker.this.preProcessMessage(payload)) == null) continue;
                    MuleMessage muleMessage = AbstractReceiverWorker.this.receiver.createMuleMessage(payload, AbstractReceiverWorker.this.endpoint.getEncoding());
                    AbstractReceiverWorker.this.preRouteMuleMessage(muleMessage);
                    SessionHandler handler = AbstractReceiverWorker.this.endpoint.getConnector() instanceof AbstractConnector ? ((AbstractConnector)AbstractReceiverWorker.this.endpoint.getConnector()).getSessionHandler() : new MuleSessionHandler();
                    try {
                        session = handler.retrieveSessionInfoFromMessage(muleMessage);
                    }
                    catch (SerializationException e) {
                        session = new LegacySessionHandler().retrieveSessionInfoFromMessage(muleMessage);
                    }
                    if ((result = (resultEvent = session != null ? AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, session, tx, AbstractReceiverWorker.this.out) : AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, tx, AbstractReceiverWorker.this.out)) == null ? null : resultEvent.getMessage()) == null || (payload = AbstractReceiverWorker.this.postProcessMessage(result)) == null) continue;
                    results.add(payload);
                }
                return results;
            }
        };
        try {
            List results = (List)tt.execute(cb);
            this.handleResults(results);
        }
        finally {
            this.messages.clear();
        }
    }

    protected void preRouteMuleMessage(MuleMessage message) throws Exception {
    }

    protected abstract void bindTransaction(Transaction var1) throws TransactionException;

    protected void handleResults(List messages) throws Exception {
    }

    protected Object preProcessMessage(Object message) throws Exception {
        return message;
    }

    protected MuleMessage postProcessMessage(MuleMessage message) throws Exception {
        return message;
    }

    public void release() {
    }
}

