/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCollection;

public final class TransactionCoordination {
    protected static final Log logger = LogFactory.getLog(TransactionCoordination.class);
    private static final TransactionCoordination instance = new TransactionCoordination();
    private final ThreadLocal<Transaction> transactions = new ThreadLocal();
    private final Object txCounterLock = new Object();
    private int txCounter = 0;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        return instance;
    }

    public Transaction getTransaction() {
        return this.transactions.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = this.transactions.get();
        if (oldTx instanceof TransactionCollection && !((TransactionCollection)((Object)oldTx)).getTxCollection().isEmpty()) {
            return;
        }
        try {
            if (oldTx != null && !oldTx.equals(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionCannotUnbind());
            }
        }
        finally {
            this.transactions.set(null);
            this.logTransactionUnbound(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTransactionUnbound(Transaction transaction) {
        int txCounter = 0;
        Object object = this.txCounterLock;
        synchronized (object) {
            if (this.txCounter > 0) {
                txCounter = --this.txCounter;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unbinding transaction (" + txCounter + ") " + transaction));
        }
    }

    public void bindTransaction(Transaction transaction) throws TransactionException {
        Transaction oldTx = this.transactions.get();
        if (oldTx != null && !(oldTx instanceof TransactionCollection)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
        }
        if (oldTx instanceof TransactionCollection) {
            TransactionCollection txCollection = (TransactionCollection)((Object)oldTx);
            if (txCollection.getTxCollection().contains(transaction)) {
                throw new IllegalTransactionStateException(CoreMessages.transactionAlreadyBound());
            }
            return;
        }
        this.transactions.set(transaction);
        this.logTransactionBound(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTransactionBound(Transaction transaction) {
        int txCounter;
        Object object = this.txCounterLock;
        synchronized (object) {
            txCounter = ++this.txCounter;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding new transaction (" + txCounter + ") " + transaction));
        }
    }
}

