/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.security.SecurityContext;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

public final class DefaultMuleSession
implements MuleSession,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog(DefaultMuleSession.class);
    private transient FlowConstruct flowConstruct = null;
    private boolean valid = true;
    private String id;
    private SecurityContext securityContext;
    private Map<String, Object> properties = null;
    private transient MuleContext muleContext;
    private transient Map<String, Object> serializedData = null;

    public DefaultMuleSession(MuleContext muleContext) {
        this((FlowConstruct)null, muleContext);
    }

    public DefaultMuleSession(FlowConstruct flowConstruct, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
        this.id = UUID.getUUID();
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, FlowConstruct flowConstruct, MuleContext muleContext) throws MuleException {
        this(message, requestSessionHandler, muleContext);
        if (flowConstruct == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("flowConstruct").toString());
        }
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleMessage message, SessionHandler requestSessionHandler, MuleContext muleContext) throws MuleException {
        this(muleContext);
        if (requestSessionHandler == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("requestSessionHandler").toString());
        }
        if (message == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("message").toString());
        }
        this.properties = new CaseInsensitiveMap();
        requestSessionHandler.retrieveSessionInfoFromMessage(message, this);
        this.id = (String)this.getProperty(requestSessionHandler.getSessionIDKey());
        if (this.id == null) {
            this.id = UUID.getUUID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There is no session id on the request using key: " + requestSessionHandler.getSessionIDKey() + ". Generating new session id: " + this.id));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got session with id: " + this.id));
        }
    }

    public DefaultMuleSession(MuleSession session, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.id = session.getId();
        this.securityContext = session.getSecurityContext();
        this.flowConstruct = session.getFlowConstruct();
        this.valid = session.isValid();
        this.properties = new HashMap<String, Object>();
        for (String key : session.getPropertyNamesAsSet()) {
            this.properties.put(key, session.getProperty(key));
        }
    }

    public DefaultMuleSession(MuleSession source, FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        DefaultMuleSession session = (DefaultMuleSession)source;
        this.id = session.id;
        this.muleContext = session.muleContext;
        this.properties = session.properties;
        this.securityContext = session.securityContext;
        this.valid = session.valid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean value) {
        this.valid = value;
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public <T> T getProperty(Object key) {
        return (T)this.properties.get(key);
    }

    @Override
    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    @Override
    @Deprecated
    public Iterator<String> getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public Set<String> getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.serializedData != null) {
            Object serviceName = this.serializedData.get("serviceName");
            if (serviceName != null) {
                out.writeObject(serviceName);
            }
        } else if (this.getFlowConstruct() != null) {
            out.writeObject(this.getFlowConstruct() != null ? this.getFlowConstruct().getName() : "null");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        try {
            this.serializedData.put("serviceName", in.readObject());
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        if (this.serializedData == null) {
            return;
        }
        String serviceName = (String)this.serializedData.get("serviceName");
        if (serviceName != null) {
            this.flowConstruct = context.getRegistry().lookupFlowConstruct(serviceName);
        }
        this.serializedData = null;
    }
}

