/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.requestreply;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.routing.requestreply.AbstractAsyncRequestReplyRequester;

public class SimpleAsyncRequestReplyRequester
extends AbstractAsyncRequestReplyRequester
implements Startable,
Stoppable {
    protected MessageProcessor requestMessageProcessor;

    @Override
    protected void sendAsyncRequest(MuleEvent event) throws MuleException {
        this.setAsyncReplyProperties(event);
        this.requestMessageProcessor.process(event);
    }

    protected void setAsyncReplyProperties(MuleEvent event) throws MuleException {
        event.getMessage().setReplyTo(this.getReplyTo());
        event.getMessage().setOutboundProperty("MULE_REPLYTO_REQUESTOR", event.getFlowConstruct().getName());
        String correlation = event.getFlowConstruct().getMessageInfoMapping().getCorrelationId(event.getMessage());
        event.getMessage().setCorrelationId(correlation);
    }

    private String getReplyTo() {
        return ((InboundEndpoint)this.replyMessageSource).getEndpointURI().getAddress();
    }

    @Override
    protected void verifyReplyMessageSource(MessageSource messageSource) {
        if (!(messageSource instanceof InboundEndpoint)) {
            throw new IllegalArgumentException("Only an InboundEndpoint reply MessageSource is supported with SimpleAsyncRequestReplyRequester");
        }
    }

    public void setMessageProcessor(MessageProcessor processor) {
        this.requestMessageProcessor = processor;
    }

    @Deprecated
    public void setMessageSource(MessageSource source) {
        this.setReplySource(source);
    }

    @Override
    public void start() throws MuleException {
        if (this.replyMessageSource != null) {
            if (this.replyMessageSource instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)this.replyMessageSource)).setFlowConstruct(this.flowConstruct);
            }
            if (this.replyMessageSource instanceof Initialisable) {
                ((Initialisable)((Object)this.replyMessageSource)).initialise();
            }
            if (this.replyMessageSource instanceof Startable) {
                ((Startable)((Object)this.replyMessageSource)).start();
            }
        }
        if (this.requestMessageProcessor != null) {
            if (this.requestMessageProcessor instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)this.requestMessageProcessor)).setFlowConstruct(this.flowConstruct);
            }
            if (this.requestMessageProcessor instanceof Initialisable) {
                ((Initialisable)((Object)this.requestMessageProcessor)).initialise();
            }
            if (this.requestMessageProcessor instanceof Startable) {
                ((Startable)((Object)this.requestMessageProcessor)).start();
            }
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.replyMessageSource != null && this.replyMessageSource instanceof Stoppable) {
            ((Stoppable)((Object)this.replyMessageSource)).stop();
            if (this.requestMessageProcessor != null && this.requestMessageProcessor instanceof Stoppable) {
                ((Stoppable)((Object)this.requestMessageProcessor)).stop();
            }
        }
        if (this.requestMessageProcessor != null) {
            if (this.requestMessageProcessor instanceof Stoppable) {
                ((Stoppable)((Object)this.requestMessageProcessor)).stop();
            }
            if (this.requestMessageProcessor instanceof Disposable) {
                ((Disposable)((Object)this.requestMessageProcessor)).dispose();
            }
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        if (this.requestMessageProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.requestMessageProcessor)).setMuleContext(context);
        }
    }
}

