/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.mule.api.construct.PipelineProcessingStrategy;
import org.mule.construct.AsynchronousProcessingStrategy;
import org.mule.management.stats.AbstractFlowConstructStatistics;
import org.mule.management.stats.ComponentStatistics;
import org.mule.management.stats.QueueStatistics;

public class FlowConstructStatistics
extends AbstractFlowConstructStatistics
implements QueueStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    private int threadPoolSize = 0;
    protected final ComponentStatistics flowStatistics = new ComponentStatistics();
    private long queuedEvent = 0L;
    private long maxQueuedEvent = 0L;
    private long averageQueueSize = 0L;
    private long totalQueuedEvent = 0L;

    public FlowConstructStatistics(String flowConstructType, String name, PipelineProcessingStrategy processingStrategy) {
        super(flowConstructType, name);
        this.flowStatistics.setEnabled(this.enabled);
        if (processingStrategy instanceof AsynchronousProcessingStrategy) {
            this.threadPoolSize = ((AsynchronousProcessingStrategy)processingStrategy).getMaxThreads();
        }
        if (this.getClass() == FlowConstructStatistics.class) {
            this.clear();
        }
    }

    public FlowConstructStatistics(String flowConstructType, String name, int maxThreadSize) {
        super(flowConstructType, name);
        this.flowStatistics.setEnabled(this.enabled);
        this.threadPoolSize = maxThreadSize;
        if (this.getClass() == FlowConstructStatistics.class) {
            this.clear();
        }
    }

    public FlowConstructStatistics(String flowConstructType, String name) {
        this(flowConstructType, name, null);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void incExecutionError() {
        this.executionError.addAndGet(1L);
    }

    public void incFatalError() {
        this.fatalError.addAndGet(1L);
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        this.flowStatistics.setEnabled(this.enabled);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.flowStatistics != null) {
            this.flowStatistics.clear();
        }
    }

    public void addCompleteFlowExecutionTime(long time) {
        this.flowStatistics.addCompleteExecutionTime(time);
    }

    public void addFlowExecutionBranchTime(long time, long total) {
        this.flowStatistics.addExecutionBranchTime(time == total, time, total);
    }

    public long getAverageProcessingTime() {
        return this.flowStatistics.getAverageExecutionTime();
    }

    public long getProcessedEvents() {
        return this.flowStatistics.getExecutedEvents();
    }

    public long getMaxProcessingTime() {
        return this.flowStatistics.getMaxExecutionTime();
    }

    public long getMinProcessingTime() {
        return this.flowStatistics.getMinExecutionTime();
    }

    public long getTotalProcessingTime() {
        return this.flowStatistics.getTotalExecutionTime();
    }

    public long getExecutionErrors() {
        return this.executionError.get();
    }

    public long getFatalErrors() {
        return this.fatalError.get();
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public synchronized void incQueuedEvent() {
        ++this.queuedEvent;
        ++this.totalQueuedEvent;
        if (this.queuedEvent > this.maxQueuedEvent) {
            this.maxQueuedEvent = this.queuedEvent;
        }
        this.averageQueueSize = this.receivedEventASync.get() / this.totalQueuedEvent;
    }

    @Override
    public synchronized void decQueuedEvent() {
        --this.queuedEvent;
    }

    public synchronized long getAverageQueueSize() {
        return this.averageQueueSize;
    }
}

