/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor.policy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.policy.AroundPolicy;
import org.mule.api.processor.policy.PolicyInvocation;

public class TimingPolicy
implements AroundPolicy {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public String getName() {
        return "simple timing policy";
    }

    @Override
    public MuleEvent invoke(PolicyInvocation invocation) throws MuleException {
        MuleEvent invocationEvent = invocation.getEvent();
        long startTime = System.currentTimeMillis();
        MuleEvent result = invocation.proceed();
        long executionTime = System.currentTimeMillis() - startTime;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("%s took %dms to process event [%s]", invocationEvent.getFlowConstruct().getName(), executionTime, invocationEvent.getId()));
        }
        return result;
    }
}

