/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.StringUtils;

public class LoggerMessageProcessor
implements MessageProcessor,
Initialisable,
MuleContextAware {
    protected transient Log logger;
    protected String message;
    protected String category;
    protected String level = "DEBUG";
    protected MuleContext muleContext;
    protected ExpressionManager expressionManager;

    @Override
    public void initialise() throws InitialisationException {
        this.initLogger();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void initLogger() {
        this.logger = this.category != null ? LogFactory.getLog((String)this.category) : LogFactory.getLog(LoggerMessageProcessor.class);
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        this.log(event);
        return event;
    }

    protected void log(MuleEvent event) {
        if (event == null) {
            this.logWithLevel(null, this.level);
        } else if (StringUtils.isEmpty((String)this.message)) {
            this.logWithLevel(event.getMessage(), this.level);
        } else {
            this.logWithLevel(this.expressionManager.parse(this.message, event.getMessage()), this.level);
        }
    }

    protected void logWithLevel(Object object, String level) {
        if ("ERROR".equals(level)) {
            this.logger.error(object);
        } else if ("WARN".equals(level)) {
            this.logger.warn(object);
        } else if ("INFO".equals(level)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(object);
            }
        } else if ("DEBUG".equals(level)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(object);
            }
        } else if ("TRACE".equals(level) && this.logger.isTraceEnabled()) {
            this.logger.trace(object);
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(String level) {
        this.level = level.toUpperCase();
    }
}

