/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.compression.AbstractCompressionTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.SerializationUtils;
import org.mule.util.compression.GZipCompression;

public class GZipCompressTransformer
extends AbstractCompressionTransformer {
    public GZipCompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataTypeFactory.create(Serializable.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            byte[] data = null;
            if (src instanceof byte[]) {
                data = (byte[])src;
            } else if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    data = IOUtils.toByteArray(input);
                }
                finally {
                    input.close();
                }
            } else {
                data = SerializationUtils.serialize((Serializable)((Serializable)src));
            }
            return this.getStrategy().compressByteArray(data);
        }
        catch (IOException ioex) {
            throw new TransformerException(this, (Throwable)ioex);
        }
    }
}

