/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class TransformerRouter
extends AbstractOutboundRouter {
    private Transformer transformer;

    public MuleEvent route(MuleEvent event) throws MessagingException {
        MuleMessage message = event.getMessage();
        if (this.transformer != null) {
            try {
                Object payload = this.transformer.transform(message.getPayload());
                message = new DefaultMuleMessage(payload, message, this.muleContext);
                this.propagateMagicProperties(message, message);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), event, (MessageProcessor)this.routes.get(0), e);
            }
        }
        return message == null ? null : new DefaultMuleEvent(message, event);
    }

    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

