/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.util.ClassUtils;

public class PayloadTypeFilter
implements Filter {
    private Class expectedType;

    public PayloadTypeFilter() {
    }

    public PayloadTypeFilter(String expectedType) throws ClassNotFoundException {
        this(ClassUtils.loadClass(expectedType, PayloadTypeFilter.class));
    }

    public PayloadTypeFilter(Class expectedType) {
        this.expectedType = expectedType;
    }

    public boolean accept(MuleMessage message) {
        return this.expectedType != null ? this.expectedType.isAssignableFrom(message.getPayload().getClass()) : false;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public void setExpectedType(Class expectedType) {
        this.expectedType = expectedType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PayloadTypeFilter other = (PayloadTypeFilter)obj;
        return ClassUtils.equal(this.expectedType, other.expectedType);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.expectedType});
    }
}

