/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.CorrelationMode;
import org.mule.routing.DefaultRouterResultsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSplitter
extends AbstractInterceptingMessageProcessor
implements MuleContextAware {
    protected MuleContext muleContext;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected CorrelationMode enableCorrelation = CorrelationMode.IF_NOT_SET;
    protected MessageInfoMapping messageInfoMapping;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isSplitRequired(event)) {
            List<MuleMessage> parts = this.splitMessage(event);
            if (parts.size() > 0) {
                if (parts.size() <= 1) {
                    this.logger.warn((Object)"Splitter only returned a single result. If this is not expected, please check your split expression");
                }
                return this.resultsHandler.aggregateResults(this.processParts(parts, event), event, this.muleContext);
            }
            this.logger.warn((Object)"Splitter returned no results. If this is not expected, please check your split expression");
            return null;
        }
        return this.processNext(event);
    }

    protected boolean isSplitRequired(MuleEvent event) {
        return true;
    }

    protected abstract List<MuleMessage> splitMessage(MuleEvent var1) throws MuleException;

    protected List<MuleEvent> processParts(List parts, MuleEvent event) throws MuleException {
        if (this.messageInfoMapping == null) {
            this.messageInfoMapping = event.getFlowConstruct().getMessageInfoMapping();
        }
        String correlationId = this.messageInfoMapping.getCorrelationId(event.getMessage());
        ArrayList<MuleEvent> resultEvents = new ArrayList<MuleEvent>();
        int correlationSequence = 1;
        MuleMessage originalMessage = event.getMessage();
        for (Object part : parts) {
            MuleMessage message;
            if (part instanceof MuleMessage) {
                message = (MuleMessage)part;
            } else {
                message = new DefaultMuleMessage(originalMessage, this.muleContext);
                message.setPayload(part);
            }
            if (this.enableCorrelation != CorrelationMode.NEVER) {
                boolean correlationSet;
                boolean bl = correlationSet = message.getCorrelationId() != null;
                if (!correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET || this.enableCorrelation == CorrelationMode.ALWAYS) {
                    message.setCorrelationId(correlationId);
                }
                message.setCorrelationGroupSize(parts.size());
                message.setCorrelationSequence(correlationSequence++);
            }
            resultEvents.add(this.processNext(new DefaultMuleEvent(message, event)));
        }
        return resultEvents;
    }

    public void setEnableCorrelation(CorrelationMode enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }
}

