/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.i18n.CoreMessages;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.AsyncWorkListener;
import org.mule.work.AbstractMuleEventWork;

public class AsyncInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Startable,
Stoppable {
    protected WorkManagerSource workManagerSource;
    protected boolean doThreading = true;
    protected WorkManager workManager;

    public AsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource) {
        this.workManagerSource = workManagerSource;
    }

    @Deprecated
    public AsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource, boolean doThreading) {
        this.workManagerSource = workManagerSource;
        this.doThreading = doThreading;
    }

    public AsyncInterceptingMessageProcessor(ThreadingProfile threadingProfile, String name, int shutdownTimeout) {
        this.doThreading = threadingProfile.isDoThreading();
        this.workManager = threadingProfile.createWorkManager(name, shutdownTimeout);
        this.workManagerSource = new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return AsyncInterceptingMessageProcessor.this.workManager;
            }
        };
    }

    public void start() throws MuleException {
        if (this.workManager != null) {
            this.workManager.start();
        }
    }

    public void stop() throws MuleException {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.isProcessAsync(event)) {
            this.processNextAsync(event);
            return null;
        }
        MuleEvent response = this.processNext(event);
        return response;
    }

    protected MuleEvent processNextTimed(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        MuleEvent response = event.getFlowConstruct() != null ? new ProcessingTimeInterceptor(this.next, event.getFlowConstruct()).process(event) : this.processNext(event);
        return response;
    }

    protected boolean isProcessAsync(MuleEvent event) throws MessagingException {
        if (event.getEndpoint().getTransactionConfig().isTransacted()) {
            throw new MessagingException(CoreMessages.asyncDoesNotSupportTransactions(), event);
        }
        return this.doThreading;
    }

    protected void processNextAsync(MuleEvent event) throws MuleException {
        try {
            this.workManagerSource.getWorkManager().scheduleWork(new AsyncMessageProcessorWorker(event), Long.MAX_VALUE, null, new AsyncWorkListener(this.next));
        }
        catch (Exception e) {
            new MessagingException(CoreMessages.errorSchedulingMessageProcessorForAsyncInvocation(this.next), event, (Throwable)e);
        }
    }

    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event);
        }

        protected void doRun() {
            try {
                AsyncInterceptingMessageProcessor.this.processNextTimed(this.event);
            }
            catch (MuleException e) {
                this.event.getFlowConstruct().getExceptionListener().handleException(e, this.event);
            }
        }
    }
}

