/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import org.mule.management.stats.AllStatistics;
import org.mule.management.stats.FlowConstructStatistics;

public class ApplicationStatistics
extends FlowConstructStatistics {
    private AllStatistics parent;

    public ApplicationStatistics(AllStatistics parent) {
        super("Application", "application totals", 0);
        this.parent = parent;
    }

    public long getAverageProcessingTime() {
        long totalTime = 0L;
        long totalEvents = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            totalEvents += stats.getProcessedEvents();
            totalTime += stats.getTotalProcessingTime();
        }
        return totalEvents == 0L ? 0L : totalTime / totalEvents;
    }

    public long getProcessedEvents() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getProcessedEvents();
        }
        return total;
    }

    public long getMinProcessingTime() {
        long min = 0L;
        boolean first = true;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (!(stats instanceof ApplicationStatistics)) {
                long flowMin = stats.getMinProcessingTime();
                min = first ? flowMin : Math.min(min, flowMin);
            }
            first = false;
        }
        return min;
    }

    public long getMaxProcessingTime() {
        long max = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            max = Math.max(max, stats.getMaxProcessingTime());
        }
        return max;
    }

    public long getTotalProcessingTime() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getTotalProcessingTime();
        }
        return total;
    }

    public long getExecutionErrors() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getExecutionErrors();
        }
        return total;
    }

    public long getFatalErrors() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getFatalErrors();
        }
        return total;
    }

    public long getAsyncEventsReceived() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getAsyncEventsReceived();
        }
        return total;
    }

    public long getSyncEventsReceived() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getSyncEventsReceived();
        }
        return total;
    }

    public long getTotalEventsReceived() {
        long total = 0L;
        for (FlowConstructStatistics stats : this.parent.getServiceStatistics()) {
            if (stats instanceof ApplicationStatistics) continue;
            total += stats.getTotalEventsReceived();
        }
        return total;
    }
}

