/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.util.CollectionUtils;

public class DefaultServiceExceptionStrategy
extends AbstractMessagingExceptionStrategy {
    private boolean stopMessageProcessing;

    public DefaultServiceExceptionStrategy() {
    }

    public DefaultServiceExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    protected void doHandleException(Exception e, MuleEvent event) {
        FlowConstructStatistics statistics = this.getFlowConstructStatistics(event.getFlowConstruct());
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
        super.doHandleException(DefaultMuleConfiguration.fullStackTraces ? e : (Exception)ExceptionHelper.sanitize(e), event);
    }

    protected void logFatal(MuleEvent event, Throwable t) {
        FlowConstructStatistics statistics = this.getFlowConstructStatistics(event.getFlowConstruct());
        if (statistics != null && statistics.isEnabled()) {
            statistics.incFatalError();
        }
        super.logFatal(event, t);
    }

    protected void routeException(MuleEvent event, MessageProcessor target, Throwable t) {
        ServiceStatistics statistics;
        super.routeException(event, target, t);
        List<MessageProcessor> processors = this.getMessageProcessors();
        if (CollectionUtils.isNotEmpty(processors) && this.getFlowConstructStatistics(event.getFlowConstruct()) instanceof ServiceStatistics && (statistics = this.getServiceStatistics(event.getFlowConstruct())).isEnabled()) {
            for (MessageProcessor endpoint : processors) {
                statistics.getOutboundRouterStat().incrementRoutedMessage(endpoint);
            }
        }
        if (this.stopMessageProcessing) {
            this.stopFlowConstruct();
        }
    }

    private void stopFlowConstruct() {
        if (this.flowConstruct instanceof Stoppable) {
            this.logger.info((Object)("Stopping flow '" + this.flowConstruct.getName() + "' due to exception"));
            try {
                ((Lifecycle)((Object)this.flowConstruct)).stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)("Unable to stop flow '" + this.flowConstruct.getName() + "'"), (Throwable)e);
            }
        } else {
            this.logger.warn((Object)"Flow is not stoppable");
        }
    }

    protected FlowConstructStatistics getFlowConstructStatistics(FlowConstruct flowConstruct) {
        if (flowConstruct != null) {
            return flowConstruct.getStatistics();
        }
        return null;
    }

    protected ServiceStatistics getServiceStatistics(FlowConstruct flowConstruct) {
        FlowConstructStatistics stats = this.getFlowConstructStatistics(flowConstruct);
        if (!(stats instanceof ServiceStatistics)) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current service on the context. Please report this to dev@mule.codehaus.org");
            return null;
        }
        return (ServiceStatistics)stats;
    }

    public boolean isStopMessageProcessing() {
        return this.stopMessageProcessing;
    }

    public void setStopMessageProcessing(boolean stopMessageProcessing) {
        this.stopMessageProcessing = stopMessageProcessing;
    }
}

