/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.config.pool.ThreadPoolFactory;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.NamedThreadFactory;
import org.mule.util.concurrent.WaitPolicy;

public class DefaultThreadPoolFactory
extends ThreadPoolFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public ThreadPoolExecutor createPool(String name, ThreadingProfile tp) {
        Object buffer = tp.getMaxBufferSize() > 0 && tp.getMaxThreadsActive() > 1 ? new LinkedBlockingDeque(tp.getMaxBufferSize()) : new SynchronousQueue();
        ThreadPoolExecutor pool = this.internalCreatePool(name, tp, (BlockingQueue)buffer);
        this.configureThreadFactory(name, tp, pool);
        if (tp.getRejectedExecutionHandler() != null) {
            pool.setRejectedExecutionHandler(tp.getRejectedExecutionHandler());
        } else {
            switch (tp.getPoolExhaustedAction()) {
                case 2: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
                    break;
                }
                case 4: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
                    break;
                }
                case 3: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
                    break;
                }
                case 1: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
                    break;
                }
                default: {
                    pool.setRejectedExecutionHandler((RejectedExecutionHandler)new WaitPolicy(tp.getThreadWaitTimeout(), TimeUnit.MILLISECONDS));
                }
            }
        }
        return pool;
    }

    protected void configureThreadFactory(String name, ThreadingProfile tp, ThreadPoolExecutor pool) {
        if (tp.getThreadFactory() != null) {
            pool.setThreadFactory(tp.getThreadFactory());
        } else if (StringUtils.isNotBlank((String)name)) {
            pool.setThreadFactory((ThreadFactory)new NamedThreadFactory(name, MuleContext.class.getClassLoader()));
        }
    }

    protected ThreadPoolExecutor internalCreatePool(String name, ThreadingProfile tp, BlockingQueue buffer) {
        return new ThreadPoolExecutor(Math.min(tp.getMaxThreadsIdle(), tp.getMaxThreadsActive()), tp.getMaxThreadsActive(), tp.getThreadTTL(), TimeUnit.MILLISECONDS, buffer);
    }
}

