/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.security;

import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class UnauthorisedException
extends SecurityException {
    private static final long serialVersionUID = -6664384216189042673L;

    public UnauthorisedException(Message message) {
        super(message, RequestContext.getEvent());
    }

    public UnauthorisedException(Message message, Throwable cause) {
        super(message, RequestContext.getEvent(), cause);
    }

    public UnauthorisedException(Message message, MuleEvent event) {
        super(message, event);
    }

    public UnauthorisedException(Message message, MuleEvent event, Throwable cause) {
        super(message, event, cause);
    }

    public UnauthorisedException(MuleEvent event, SecurityContext context, SecurityFilter filter) {
        super(UnauthorisedException.constructMessage(context, event.getEndpoint(), filter), event);
    }

    @Deprecated
    public UnauthorisedException(MuleEvent event, SecurityContext context, ImmutableEndpoint endpoint, SecurityFilter filter) {
        super(UnauthorisedException.constructMessage(context, endpoint, filter), event);
    }

    private static Message constructMessage(SecurityContext context, ImmutableEndpoint endpoint, SecurityFilter filter) {
        Message m = context == null ? CoreMessages.authSetButNoContext(filter.getClass().getName()) : CoreMessages.authFailedForUser(context.getAuthentication().getPrincipal());
        m.setNextMessage(CoreMessages.authDeniedOnEndpoint(endpoint.getEndpointURI()));
        return m;
    }
}

