/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan.annotations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.scan.ClassScanner;
import org.mule.util.scan.annotations.AnnotationFilter;
import org.mule.util.scan.annotations.AnnotationInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsScanner
extends EmptyVisitor
implements ClassScanner {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<AnnotationInfo> classAnnotations = new ArrayList<AnnotationInfo>();
    private List<AnnotationInfo> fieldAnnotations = new ArrayList<AnnotationInfo>();
    private List<AnnotationInfo> methodAnnotations = new ArrayList<AnnotationInfo>();
    private List<AnnotationInfo> paramAnnotations = new ArrayList<AnnotationInfo>();
    protected AnnotationInfo currentAnnotation;
    protected static final int PROCESSING_FIELD = 1;
    protected static final int PROCESSING_METHOD = 2;
    protected static final int PROCESSING_CLASS = 3;
    protected static final int PROCESSING_PARAM = 4;
    protected BitSet currentlyProcessing = new BitSet(4);
    private AnnotationFilter filter;
    private BitSet lastProcessing = null;
    private String className;
    private boolean match;

    public AnnotationsScanner() {
    }

    public AnnotationsScanner(AnnotationFilter filter) {
        this.filter = filter;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.currentAnnotation = new AnnotationInfo();
        this.currentAnnotation.setClassName(this.getAnnotationClassName(desc));
        this.currentlyProcessing.set(4);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Parameter Annotation: " + this.getAnnotationClassName(desc)));
        }
        return this;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.currentlyProcessing.nextSetBit(0) < 0) {
            if (this.lastProcessing != null) {
                this.currentlyProcessing = this.lastProcessing;
            } else {
                return this;
            }
        }
        this.currentAnnotation = new AnnotationInfo();
        this.currentAnnotation.setClassName(this.getAnnotationClassName(desc));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Annotation: " + this.getAnnotationClassName(desc)));
        }
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentlyProcessing.set(3);
        this.className = name;
    }

    public void visit(String name, Object value) {
        if (this.currentAnnotation != null) {
            this.currentAnnotation.getParams().add(new AnnotationInfo.NameValue(name, value));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("          : " + name + "=" + value));
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.currentlyProcessing.set(1);
        return this;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.currentlyProcessing.set(2);
        return this;
    }

    public void visitEnd() {
        if (this.currentAnnotation != null) {
            if (this.filter != null && !this.filter.accept(this.currentAnnotation)) {
                this.currentlyProcessing.clear();
                this.currentAnnotation = null;
                return;
            }
            if (this.currentlyProcessing.get(3)) {
                this.classAnnotations.add(this.currentAnnotation);
                this.match = true;
            }
            if (this.currentlyProcessing.get(1)) {
                this.fieldAnnotations.add(this.currentAnnotation);
                this.match = true;
            } else if (this.currentlyProcessing.get(4)) {
                this.paramAnnotations.add(this.currentAnnotation);
                this.match = true;
            } else if (this.currentlyProcessing.get(2)) {
                this.methodAnnotations.add(this.currentAnnotation);
                this.match = true;
            }
            this.currentAnnotation = null;
        }
        this.lastProcessing = (BitSet)this.currentlyProcessing.clone();
        this.currentlyProcessing.clear();
    }

    public String getAnnotationClassName(String rawName) {
        return rawName.substring(1, rawName.length() - 1).replace('/', '.');
    }

    public List<AnnotationInfo> getClassAnnotations() {
        return this.classAnnotations;
    }

    public List<AnnotationInfo> getFieldAnnotations() {
        return this.fieldAnnotations;
    }

    public List<AnnotationInfo> getMethodAnnotations() {
        return this.methodAnnotations;
    }

    public List<AnnotationInfo> getParamAnnotations() {
        return this.paramAnnotations;
    }

    public List<AnnotationInfo> getAllAnnotations() {
        ArrayList<AnnotationInfo> list = new ArrayList<AnnotationInfo>();
        list.addAll(this.classAnnotations);
        list.addAll(this.fieldAnnotations);
        list.addAll(this.methodAnnotations);
        list.addAll(this.paramAnnotations);
        return list;
    }

    @Override
    public boolean isMatch() {
        return this.match;
    }

    @Override
    public String getClassName() {
        return this.className;
    }
}

