/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private String className;
    private List<NameValue> params = new ArrayList<NameValue>();

    public List<NameValue> getParams() {
        return this.params;
    }

    public Map<String, Object> getParamsAsMap() {
        HashMap<String, Object> m = new HashMap<String, Object>(this.params.size());
        for (NameValue param : this.params) {
            m.put(param.name, param.value);
        }
        return m;
    }

    public void setParams(List<NameValue> params) {
        this.params = params;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInfo that = (AnnotationInfo)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return !(this.params != null ? !((Object)this.params).equals(that.params) : that.params != null);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.params.size() * 20);
        sb.append(this.className).append('(');
        for (int i = 0; i < this.params.size(); ++i) {
            NameValue param = this.params.get(i);
            sb.append(param.name).append('=').append(param.value);
            if (i < this.params.size() - 1) {
                sb.append(',');
                continue;
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static class NameValue {
        public String name;
        public Object value;

        NameValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameValue nameValue = (NameValue)o;
            if (!this.name.equals(nameValue.name)) {
                return false;
            }
            return this.value.equals(nameValue.value);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.value);
        }
    }
}

