/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ArrayUtils
extends org.apache.commons.lang.ArrayUtils {
    public static String toString(Object array, int maxElements) {
        String result;
        Class<?> componentType = array.getClass().getComponentType();
        if (Object.class.isAssignableFrom(componentType)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])((Object[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Boolean.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((boolean[])((boolean[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Byte.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((byte[])((byte[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Character.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((char[])((char[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Short.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((short[])((short[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Integer.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((int[])((int[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Long.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((long[])((long[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Float.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((float[])((float[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Double.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((double[])((double[])array), (int)0, (int)maxElements));
        } else {
            throw new IllegalArgumentException("Unknown array service type: " + componentType.getName());
        }
        if (Array.getLength(array) > maxElements) {
            StringBuffer buf = new StringBuffer(result);
            buf.insert(buf.length() - 1, " [..]");
            result = buf.toString();
        }
        return result;
    }

    public static Object[] toArrayOfComponentType(Object[] objects, Class clazz) {
        if (objects == null || objects.getClass().getComponentType().equals(clazz)) {
            return objects;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Array target class must not be null");
        }
        Object[] result = (Object[])Array.newInstance(clazz, objects.length);
        System.arraycopy(objects, 0, result, 0, objects.length);
        return result;
    }

    public static Object[] setDifference(Object[] a, Object[] b) {
        HashSet<Object> aCollecn = new HashSet<Object>(Arrays.asList(a));
        List<Object> bCollecn = Arrays.asList(b);
        aCollecn.removeAll(bCollecn);
        return aCollecn.toArray();
    }

    public static String[] setDifference(String[] a, String[] b) {
        Object[] ugly = ArrayUtils.setDifference((Object[])a, (Object[])b);
        String[] copy = new String[ugly.length];
        System.arraycopy(ugly, 0, copy, 0, ugly.length);
        return copy;
    }
}

