/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.LifecycleStateEnabled;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.ConnectionNotification;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransportMessageHandler<O>
implements Connectable,
LifecycleStateEnabled {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ImmutableEndpoint endpoint;
    protected final AbstractConnector connector;
    protected RetryPolicyTemplate retryTemplate;
    protected MuleMessageFactory muleMessageFactory = null;
    protected ConnectableLifecycleManager<O> lifecycleManager;
    protected final AtomicBoolean connected = new AtomicBoolean(false);

    public AbstractTransportMessageHandler(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (AbstractConnector)endpoint.getConnector();
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected abstract ConnectableLifecycleManager<O> createLifecycleManager();

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    protected void disposeAndLogException() {
        try {
            this.dispose();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Could not dispose of the message dispatcher!", t);
        }
    }

    public boolean validate() {
        return !this.getLifecycleState().isDisposed();
    }

    public void activate() {
    }

    public void passivate() {
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<O>(){

                @Override
                public void onTransition(String phaseName, O object) throws MuleException {
                    AbstractTransportMessageHandler.this.initializeRetryPolicy();
                    AbstractTransportMessageHandler.this.initializeMessageFactory();
                    AbstractTransportMessageHandler.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void initializeRetryPolicy() {
        this.retryTemplate = this.endpoint.getRetryPolicyTemplate() != null ? this.endpoint.getRetryPolicyTemplate() : this.connector.getRetryPolicyTemplate();
    }

    protected void initializeMessageFactory() throws InitialisationException {
        try {
            this.muleMessageFactory = this.connector.getMuleMessageFactory();
        }
        catch (CreateException ce) {
            Message message = MessageFactory.createStaticMessage(ce.getMessage());
            throw new InitialisationException(message, (Throwable)ce, this);
        }
    }

    @Override
    public synchronized void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            if (this.isConnected()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<O>(){

                @Override
                public void onTransition(String phaseName, O object) throws MuleException {
                    AbstractTransportMessageHandler.this.doDispose();
                }
            });
        }
        catch (MuleException e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final synchronized void connect() throws Exception {
        if (this.connected.get()) {
            return;
        }
        if (this.getLifecycleState().isDisposed()) {
            throw new IllegalStateException("Requester/dispatcher has been disposed; cannot connect to resource:" + this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connecting: " + this));
        }
        this.doConnect();
        this.connected.set(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connected: " + this.getConnectionDescription()));
        }
    }

    @Override
    public RetryContext validateConnection(RetryContext retryContext) {
        retryContext.setOk();
        return retryContext;
    }

    @Override
    public final synchronized void disconnect() throws Exception {
        if (this.isStarted()) {
            this.stop();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting: " + this));
        }
        this.doDisconnect();
        this.connected.set(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnected: " + this));
        }
        this.connector.fireNotification(new ConnectionNotification(this, this.getConnectEventId(this.endpoint), 703));
    }

    protected String getConnectEventId(ImmutableEndpoint endpoint) {
        return this.connector.getName() + ".dispatcher(" + endpoint.getEndpointURI().getUri() + ")";
    }

    @Override
    public final boolean isConnected() {
        return this.connected.get();
    }

    protected boolean isDoThreading() {
        return this.connector.getDispatcherThreadingProfile().isDoThreading();
    }

    @Override
    public String getConnectionDescription() {
        return "endpoint.outbound." + this.endpoint.getEndpointURI().toString();
    }

    @Override
    public final void start() throws MuleException {
        if (this.isStarted() || this.isStarting()) {
            return;
        }
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (MuleException me) {
                throw me;
            }
            catch (Exception e) {
                throw new ConnectException(e, (Connectable)this);
            }
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<O>(){

            @Override
            public void onTransition(String phaseName, O object) throws MuleException {
                AbstractTransportMessageHandler.this.doStart();
            }
        });
    }

    @Override
    public final void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<O>(){

            @Override
            public void onTransition(String phaseName, O object) throws MuleException {
                try {
                    AbstractTransportMessageHandler.this.doStop();
                }
                catch (MuleException e) {
                    AbstractTransportMessageHandler.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append(", disposed=").append(this.getLifecycleState().isDisposed());
        sb.append('}');
        return sb.toString();
    }

    public void setEndpoint(ImmutableEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        this.endpoint = endpoint;
    }

    protected abstract WorkManager getWorkManager() throws MuleException;

    public boolean isStarted() {
        return this.getLifecycleState().isStarted();
    }

    public boolean isStarting() {
        return this.getLifecycleState().isStarting();
    }

    public boolean isStopping() {
        return this.getLifecycleState().isStopping();
    }

    protected MuleMessageFactory createMuleMessageFactory() throws CreateException {
        return this.connector.createMuleMessageFactory();
    }

    public MuleMessage createMuleMessage(Object transportMessage, MuleMessage previousMessage, String encoding) throws MuleException {
        try {
            return this.muleMessageFactory.create(transportMessage, previousMessage, encoding);
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessage"), (Object)e);
        }
    }

    public MuleMessage createMuleMessage(Object transportMessage, String encoding) throws MuleException {
        try {
            return this.muleMessageFactory.create(transportMessage, encoding);
        }
        catch (Exception e) {
            throw new CreateException(CoreMessages.failedToCreate("MuleMessage"), e, this);
        }
    }

    public MuleMessage createMuleMessage(Object transportMessage) throws MuleException {
        String encoding = this.endpoint.getMuleContext().getConfiguration().getDefaultEncoding();
        return this.createMuleMessage(transportMessage, encoding);
    }

    protected MuleMessage createNullMuleMessage() throws MuleException {
        return this.createMuleMessage(null);
    }
}

