/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.SerializationException;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AbstractAggregator;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.CollectionCorrelatorCallback;
import org.mule.routing.correlation.CorrelationSequenceComparator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.util.SerializationUtils;

public class MessageChunkAggregator
extends AbstractAggregator {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected Comparator eventComparator = new CorrelationSequenceComparator();

    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new CollectionCorrelatorCallback(muleContext){

            public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
                MuleEvent[] collectedEvents = events.toArray();
                MuleEvent firstEvent = collectedEvents[0];
                Arrays.sort(collectedEvents, MessageChunkAggregator.this.eventComparator);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                try {
                    DefaultMuleMessage message;
                    for (MuleEvent event : collectedEvents) {
                        baos.write(event.getMessageAsBytes());
                    }
                    try {
                        Object deserialized = SerializationUtils.deserialize(baos.toByteArray(), this.muleContext);
                        message = new DefaultMuleMessage(deserialized, firstEvent.getMessage(), this.muleContext);
                    }
                    catch (SerializationException e) {
                        message = new DefaultMuleMessage((Object)baos.toByteArray(), firstEvent.getMessage(), this.muleContext);
                    }
                    message.setCorrelationGroupSize(-1);
                    message.setCorrelationSequence(-1);
                    DefaultMuleEvent defaultMuleEvent = new DefaultMuleEvent(message, firstEvent);
                    return defaultMuleEvent;
                }
                catch (Exception e) {
                    throw new AggregationException(events, (MessageProcessor)MessageChunkAggregator.this, (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                }
            }
        };
    }
}

