/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.text.MessageFormat;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.mule.util.store.InMemoryObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdempotentMessageFilter
extends AbstractFilteringMessageProcessor
implements FlowConstructAware,
Initialisable {
    protected volatile ObjectStore<String> store;
    protected volatile String assignedComponentName;
    protected FlowConstruct flowConstruct;
    protected String idExpression = MessageFormat.format("{0}message:id{1}", "#[", "]");

    @Override
    public void initialise() throws InitialisationException {
        if (this.store == null) {
            this.store = this.createMessageIdStore();
        }
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        InMemoryObjectStore<String> s = new InMemoryObjectStore<String>();
        s.setName(this.assignedComponentName);
        s.setMaxEntries(-1);
        s.setEntryTTL(300000);
        s.setExpirationInterval(6000);
        s.initialise();
        return s;
    }

    @Override
    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        String id = this.getIdForEvent(event);
        try {
            this.store.store((Serializable)((Object)id), id);
            return super.processNext(event);
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToWriteMessageToStore(id, this.assignedComponentName), event, this, e);
        }
    }

    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        return event.getMuleContext().getExpressionManager().parse(this.idExpression, event.getMessage(), true);
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore<String> getStore() {
        return this.store;
    }

    public void setStore(ObjectStore<String> store) {
        this.store = store;
    }

    @Override
    protected boolean accept(MuleEvent event) {
        return event != null && this.acceptMessageForFlowConstruct(event) && this.isNewMessage(event);
    }

    protected boolean acceptMessageForFlowConstruct(MuleEvent event) {
        if (this.flowConstruct.getName().equals(event.getFlowConstruct().getName())) {
            return true;
        }
        this.logger.error((Object)("This IdempotentMessageFilter was configured on the service: " + this.assignedComponentName + " but has received an event for service: " + this.flowConstruct.getName() + ". Please check your config to make sure each service" + "has its own instance of IdempotentMessageFilter."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNewMessage(MuleEvent event) {
        try {
            String id = this.getIdForEvent(event);
            if (this.store == null) {
                IdempotentMessageFilter idempotentMessageFilter = this;
                synchronized (idempotentMessageFilter) {
                    this.initialise();
                }
            }
            return !this.store.contains((Serializable)((Object)id));
        }
        catch (MuleException e) {
            this.logger.error((Object)("Exception attempting to determine idempotency of incoming message for " + event.getFlowConstruct().getName() + " from the endpoint " + event.getEndpoint().getEndpointURI().getUri()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

