/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Arrays;
import java.util.List;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.processor.chain.AbstractMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageProcessorChain
extends AbstractMessageProcessorChain {
    protected DefaultMessageProcessorChain(List<MessageProcessor> processors) {
        super(null, processors);
    }

    protected DefaultMessageProcessorChain(MessageProcessor ... processors) {
        super(null, Arrays.asList(processors));
    }

    protected DefaultMessageProcessorChain(String name, List<MessageProcessor> processors) {
        super(name, processors);
    }

    protected DefaultMessageProcessorChain(String name, MessageProcessor ... processors) {
        super(name, Arrays.asList(processors));
    }

    public static MessageProcessorChain from(MessageProcessor messageProcessor) {
        return new DefaultMessageProcessorChain(messageProcessor);
    }

    public static MessageProcessorChain from(MessageProcessor ... messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    public static MessageProcessorChain from(List<MessageProcessor> messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws MuleException {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent currentEvent = event;
        for (MessageProcessor processor : this.processors) {
            this.fireNotification(event.getFlowConstruct(), event, processor, 1601);
            MuleEvent resultEvent = processor.process(currentEvent);
            this.fireNotification(event.getFlowConstruct(), resultEvent, processor, 1602);
            if (resultEvent != null) {
                currentEvent = resultEvent;
                continue;
            }
            if (flowConstruct instanceof SimpleFlowConstruct) {
                currentEvent = OptimizedRequestContext.criticalSetEvent(currentEvent);
                continue;
            }
            return null;
        }
        return currentEvent;
    }
}

