/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.AbstractEntryPointResolver;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitMethodEntryPointResolver
extends AbstractEntryPointResolver {
    private Set<String> methods = new LinkedHashSet<String>(2);

    public void setMethods(Set<String> methods) {
        this.methods.addAll(methods);
    }

    public void addMethod(String name) {
        this.methods.add(name);
    }

    public boolean removeMethod(String name) {
        return this.methods.remove(name);
    }

    @Override
    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        if (this.methods == null || this.methods.size() == 0) {
            throw new IllegalStateException(CoreMessages.objectIsNull("methods").toString());
        }
        Object[] payload = this.getPayloadFromMessage(context);
        Class[] classTypes = ClassUtils.getClassTypes(payload);
        Method method = null;
        for (String methodName : this.methods) {
            method = this.getMethodByName(component, methodName, context);
            if (method == null) {
                method = ClassUtils.getMethod(component.getClass(), methodName, classTypes);
            }
            if (method == null) continue;
            this.addMethodByName(component, method, context);
            Class[] parameterTypes = method.getParameterTypes();
            if (ClassUtils.compare(parameterTypes, classTypes, false)) break;
            method = null;
        }
        if (method == null) {
            InvocationResult result = new InvocationResult(this, InvocationResult.State.FAILED);
            result.setErrorNoMatchingMethods(component, classTypes);
            return result;
        }
        return this.invokeMethod(component, method, payload);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ExplicitMethodEntryPointResolver");
        sb.append("{methods=").append(StringMessageUtils.toString(this.methods));
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }
}

