/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.mule.management.stats.AbstractFlowConstructStatistics;
import org.mule.management.stats.ComponentStatistics;

public class FlowConstructStatistics
extends AbstractFlowConstructStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    private int threadPoolSize = 0;
    protected final ComponentStatistics flowStatistics = new ComponentStatistics();

    public FlowConstructStatistics(String flowConstructType, String name, int threadPoolSize) {
        super(flowConstructType, name);
        this.threadPoolSize = threadPoolSize;
        this.flowStatistics.setEnabled(this.enabled);
        if (this.getClass() == FlowConstructStatistics.class) {
            this.clear();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void incExecutionError() {
        this.executionError.addAndGet(1L);
    }

    public void incFatalError() {
        this.fatalError.addAndGet(1L);
    }

    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        this.flowStatistics.setEnabled(this.enabled);
    }

    public synchronized void clear() {
        super.clear();
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.flowStatistics != null) {
            this.flowStatistics.clear();
        }
    }

    public void addCompleteFlowExecutionTime(long time) {
        this.flowStatistics.addCompleteExecutionTime(time);
    }

    public void addFlowExecutionBranchTime(long time, long total) {
        this.flowStatistics.addExecutionBranchTime(time == total, time, total);
    }

    public long getAverageProcessingTime() {
        return this.flowStatistics.getAverageExecutionTime();
    }

    public long getProcessedEvents() {
        return this.flowStatistics.getExecutedEvents();
    }

    public long getMaxProcessingTime() {
        return this.flowStatistics.getMaxExecutionTime();
    }

    public long getMinProcessingTime() {
        return this.flowStatistics.getMinExecutionTime();
    }

    public long getTotalProcessingTime() {
        return this.flowStatistics.getTotalExecutionTime();
    }

    public long getExecutionErrors() {
        return this.executionError.get();
    }

    public long getFatalErrors() {
        return this.fatalError.get();
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }
}

