/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.lang.reflect.InvocationTargetException;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;

public class DefaultSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    public DefaultSystemExceptionStrategy() {
    }

    public DefaultSystemExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    public void handleException(Exception e) {
        AbstractConnector connector = null;
        if (e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            Exception exception = e = t instanceof Exception ? (Exception)t : new Exception(t);
        }
        if (this.enableNotifications) {
            this.fireNotification(new ExceptionNotification(e));
        }
        if (e instanceof ConnectException && !((AbstractConnector)((ConnectException)e).getFailed()).isReconnecting()) {
            this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
            connector = (AbstractConnector)((ConnectException)e).getFailed();
            connector.setReconnecting(true);
            try {
                this.logger.debug((Object)("Disconnecting " + connector.getName()));
                connector.disconnect();
            }
            catch (Exception e1) {
                this.logger.error((Object)e1.getMessage());
            }
        }
        this.logException(e);
        this.handleTransaction(e);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new DefaultExceptionPayload(e));
        }
        if (connector != null) {
            try {
                this.logger.debug((Object)("Reconnecting " + connector.getName()));
                connector.connect();
                connector.setReconnecting(false);
            }
            catch (Exception e2) {
                this.logger.error((Object)e2.getMessage());
            }
        }
    }
}

