/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.NullPayload;

public abstract class AbstractMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandler {
    public MuleEvent handleException(Exception e, MuleEvent event) {
        if (this.enableNotifications) {
            this.fireNotification(new ExceptionNotification(e));
        }
        this.logException(e);
        this.doHandleException(e, event);
        this.handleTransaction(e);
        this.closeStream(event.getMessage());
        event.getMessage().setPayload(NullPayload.getInstance());
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(e);
        event.getMessage().setExceptionPayload(exceptionPayload);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(exceptionPayload);
        }
        return event;
    }

    protected void doHandleException(Exception e, MuleEvent event) {
        this.defaultHandler(e);
        MessageProcessor target = null;
        if (e instanceof RoutingException) {
            target = ((RoutingException)e).getRoute();
        }
        this.routeException(event, target, e);
    }

    protected void defaultHandler(Throwable t) {
    }
}

