/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ObjectUtils;

public class OutboundEndpointMimeTypeCheckingMessageProcessor
implements MessageProcessor {
    private OutboundEndpoint endpoint;

    public OutboundEndpointMimeTypeCheckingMessageProcessor(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MuleEvent process(MuleEvent event) throws MessagingException {
        String endpointMimeType = this.endpoint.getMimeType();
        if (endpointMimeType != null) {
            MuleMessage message = event.getMessage();
            String contentType = (String)message.getProperty("Content-Type", PropertyScope.OUTBOUND);
            if (contentType == null) {
                message.setProperty("Content-Type", endpointMimeType, PropertyScope.OUTBOUND);
            } else {
                try {
                    MimeType mt = new MimeType(contentType);
                    String messageMimeType = mt.getPrimaryType() + "/" + mt.getSubType();
                    if (!messageMimeType.equals(endpointMimeType)) {
                        throw new MessagingException(CoreMessages.unexpectedMIMEType(messageMimeType, endpointMimeType), event);
                    }
                }
                catch (MimeTypeParseException ex) {
                    throw new MessagingException(CoreMessages.illegalMIMEType(contentType), event, (Throwable)ex);
                }
            }
        }
        return event;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

