/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Policy {
    private Map<Class<? extends ServerNotification>, Collection<Sender>> eventToSenders = new HashMap<Class<? extends ServerNotification>, Collection<Sender>>();
    private ConcurrentMap knownEventsExact = new ConcurrentHashMap();
    private ConcurrentMap knownEventsSuper = new ConcurrentHashMap();

    Policy(Map<Class<? extends ServerNotificationListener>, Set<Class<? extends ServerNotification>>> interfaceToEvents, Set<ListenerSubscriptionPair> listenerSubscriptionPairs, Set<Class<? extends ServerNotificationListener>> disabledInterfaces, Set<Class<? extends ServerNotification>> disabledEvents) {
        for (ListenerSubscriptionPair pair : listenerSubscriptionPairs) {
            ServerNotificationListener listener = pair.getListener();
            for (Class<? extends ServerNotificationListener> iface : interfaceToEvents.keySet()) {
                if (!Policy.notASubclassOfAnyClassInSet(disabledInterfaces, iface) || !iface.isAssignableFrom(listener.getClass())) continue;
                Set<Class<? extends ServerNotification>> events = interfaceToEvents.get(iface);
                for (Class<? extends ServerNotification> event : events) {
                    if (!Policy.notASubclassOfAnyClassInSet(disabledEvents, event)) continue;
                    this.knownEventsExact.put(event, (Object)Boolean.TRUE);
                    this.knownEventsSuper.put(event, (Object)Boolean.TRUE);
                    if (!this.eventToSenders.containsKey(event)) {
                        this.eventToSenders.put(event, new ArrayList());
                    }
                    this.eventToSenders.get(event).add(new Sender(pair));
                }
            }
        }
    }

    protected static boolean notASubclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!disabled.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected static boolean notASuperclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!clazz.isAssignableFrom(disabled)) continue;
            return false;
        }
        return true;
    }

    void dispatch(ServerNotification notification) {
        Class<?> notfnClass;
        if (null != notification && (!this.knownEventsExact.containsKey(notfnClass = notification.getClass()) || ((Boolean)this.knownEventsExact.get(notfnClass)).booleanValue())) {
            boolean found = false;
            for (Class<? extends ServerNotification> event : this.eventToSenders.keySet()) {
                if (!event.isAssignableFrom(notfnClass)) continue;
                found = true;
                Iterator<Sender> senders = this.eventToSenders.get(event).iterator();
                while (senders.hasNext()) {
                    senders.next().dispatch(notification);
                }
            }
            this.knownEventsExact.put(notfnClass, (Object)found);
        }
    }

    boolean isNotificationEnabled(Class notfnClass) {
        Class event;
        Iterator<Object> events;
        boolean found;
        if (!this.knownEventsSuper.containsKey((Object)notfnClass)) {
            found = false;
            events = this.knownEventsSuper.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = (Boolean)this.knownEventsSuper.get((Object)event) != false && notfnClass.isAssignableFrom(event);
            }
            this.knownEventsSuper.put((Object)notfnClass, (Object)found);
        }
        if (!this.knownEventsExact.containsKey((Object)notfnClass)) {
            found = false;
            events = this.eventToSenders.keySet().iterator();
            while (events.hasNext() && !found) {
                event = (Class)events.next();
                found = event.isAssignableFrom(notfnClass);
            }
            this.knownEventsExact.put((Object)notfnClass, (Object)found);
        }
        return (Boolean)this.knownEventsSuper.get((Object)notfnClass) != false || (Boolean)this.knownEventsExact.get((Object)notfnClass) != false;
    }
}

