/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.processor.OptionalAsyncInterceptingMessageProcessor;
import org.mule.session.DefaultMuleSession;
import org.mule.util.concurrent.ThreadNameHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFlowConstruct
extends AbstractFlowConstruct
implements MessageProcessor {
    protected List<MessageProcessor> messageProcessors = Collections.emptyList();
    protected WorkManager workManager;

    public SimpleFlowConstruct(String name, MuleContext muleContext) {
        super(name, muleContext);
    }

    @Override
    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) {
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultServiceThreadingProfile();
        }
        String threadPrefix = ThreadNameHelper.flow(this.muleContext, this.getName());
        builder.chain(new ProcessIfStartedMessageProcessor(this, this.getLifecycleState()));
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new LoggingInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
        if (this.messageSource != null) {
            builder.chain(new OptionalAsyncInterceptingMessageProcessor(this.threadingProfile, threadPrefix, this.muleContext.getConfiguration().getShutdownTimeout()));
        }
        for (MessageProcessor processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleSession calledSession = new DefaultMuleSession(event.getSession(), this);
        DefaultMuleEvent newEvent = new DefaultMuleEvent(event.getMessage(), event.getEndpoint(), event, calledSession);
        RequestContext.setEvent(newEvent);
        try {
            MuleEvent muleEvent = this.messageProcessorChain.process(newEvent);
            return muleEvent;
        }
        finally {
            RequestContext.setEvent(event);
        }
    }
}

