/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.config.pool.ThreadPoolFactory;
import org.mule.work.MuleWorkManager;

public class ImmutableThreadingProfile
implements ThreadingProfile {
    private int maxThreadsActive;
    private int maxThreadsIdle;
    private int maxBufferSize;
    private long threadTTL;
    private long threadWaitTimeout;
    private int poolExhaustedAction;
    private boolean doThreading;
    private ThreadPoolFactory poolFactory = ThreadPoolFactory.newInstance();
    private ThreadingProfile.WorkManagerFactory workManagerFactory = new DefaultWorkManagerFactory();
    private RejectedExecutionHandler rejectedExecutionHandler;
    private ThreadFactory threadFactory;
    private MuleContext muleContext;

    public ImmutableThreadingProfile(int maxThreadsActive, int maxThreadsIdle, int maxBufferSize, long threadTTL, long threadWaitTimeout, int poolExhaustedAction, boolean doThreading, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) {
        this.maxThreadsActive = maxThreadsActive;
        this.maxThreadsIdle = maxThreadsIdle;
        this.maxBufferSize = maxBufferSize;
        this.threadTTL = threadTTL;
        this.threadWaitTimeout = threadWaitTimeout;
        this.poolExhaustedAction = poolExhaustedAction;
        this.doThreading = doThreading;
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.threadFactory = threadFactory;
    }

    public ImmutableThreadingProfile(ThreadingProfile tp) {
        this(tp.getMaxThreadsActive(), tp.getMaxThreadsIdle(), tp.getMaxBufferSize(), tp.getThreadTTL(), tp.getThreadWaitTimeout(), tp.getPoolExhaustedAction(), tp.isDoThreading(), tp.getRejectedExecutionHandler(), tp.getThreadFactory());
    }

    public int getMaxThreadsActive() {
        return this.maxThreadsActive;
    }

    public int getMaxThreadsIdle() {
        return this.maxThreadsIdle;
    }

    public long getThreadTTL() {
        return this.threadTTL;
    }

    public long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public int getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setMaxThreadsActive(int maxThreadsActive) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setMaxThreadsIdle(int maxThreadsIdle) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadTTL(long threadTTL) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadWaitTimeout(long threadWaitTimeout) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setPoolExhaustedAction(int poolExhaustPolicy) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ThreadingProfile.WorkManagerFactory getWorkManagerFactory() {
        return this.workManagerFactory;
    }

    public void setWorkManagerFactory(ThreadingProfile.WorkManagerFactory workManagerFactory) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public WorkManager createWorkManager(String name, int shutdownTimeout) {
        return this.workManagerFactory.createWorkManager(new ImmutableThreadingProfile(this), name, shutdownTimeout);
    }

    public ExecutorService createPool() {
        return this.createPool(null);
    }

    public ExecutorService createPool(String name) {
        return this.poolFactory.createPool(name, new ImmutableThreadingProfile(this));
    }

    public boolean isDoThreading() {
        return this.doThreading;
    }

    public void setDoThreading(boolean doThreading) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ThreadPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.workManagerFactory instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.workManagerFactory)).setMuleContext(this.muleContext);
        }
        this.poolFactory.setMuleContext(this.muleContext);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return "ThreadingProfile{maxThreadsActive=" + this.maxThreadsActive + ", maxThreadsIdle=" + this.maxThreadsIdle + ", maxBufferSize=" + this.maxBufferSize + ", threadTTL=" + this.threadTTL + ", poolExhaustedAction=" + this.poolExhaustedAction + ", threadWaitTimeout=" + this.threadWaitTimeout + ", doThreading=" + this.doThreading + ", workManagerFactory=" + this.workManagerFactory + ", rejectedExecutionHandler=" + this.rejectedExecutionHandler + ", threadFactory=" + this.threadFactory + "}";
    }

    public static class DefaultWorkManagerFactory
    implements ThreadingProfile.WorkManagerFactory,
    MuleContextAware {
        protected MuleContext muleContext;

        public WorkManager createWorkManager(ThreadingProfile profile, String name, int shutdownTimeout) {
            MuleWorkManager workManager = new MuleWorkManager(profile, name, shutdownTimeout);
            if (this.muleContext != null) {
                MuleContextAware contextAware = workManager;
                contextAware.setMuleContext(this.muleContext);
            }
            return workManager;
        }

        public void setMuleContext(MuleContext context) {
            this.muleContext = context;
        }
    }
}

