/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor.policy;

import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.policy.AroundPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyInvocation {
    private MuleEvent event;
    private List<AroundPolicy> policies = new LinkedList<AroundPolicy>();
    private volatile int currentPolicyIndex = 0;
    private MessageProcessor messageProcessor;

    public PolicyInvocation(MuleEvent event, List<AroundPolicy> policies, MessageProcessor processor) {
        this.event = event;
        this.policies = policies;
        this.messageProcessor = processor;
    }

    public MuleEvent proceed() throws MuleException {
        ++this.currentPolicyIndex;
        if (this.currentPolicyIndex == this.policies.size()) {
            return this.messageProcessor.process(this.event);
        }
        AroundPolicy currentPolicy = this.getCurrentPolicy();
        MuleEvent result = currentPolicy.invoke(this);
        this.setEvent(result);
        return this.event;
    }

    public MuleEvent getEvent() {
        return this.event;
    }

    public void setEvent(MuleEvent event) {
        this.event = event;
    }

    public AroundPolicy getCurrentPolicy() {
        return this.policies.get(this.currentPolicyIndex);
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public List<AroundPolicy> getPolicies() {
        return this.policies;
    }
}

