/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.util.PropertiesUtils;
import org.mule.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils
extends org.apache.commons.collections.MapUtils {
    public static <K, V> Map<K, V> mapWithKeysAndValues(Class<? extends Map> mapClass, K[] keys, V[] values) {
        List<K> keyCollection = keys != null ? Arrays.asList(keys) : Collections.EMPTY_LIST;
        List<V> valuesCollection = values != null ? Arrays.asList(values) : Collections.EMPTY_LIST;
        return MapUtils.mapWithKeysAndValues(mapClass, keyCollection.iterator(), valuesCollection.iterator());
    }

    public static <K, V> Map<K, V> mapWithKeysAndValues(Class<? extends Map> mapClass, Collection<K> keys, Collection<V> values) {
        keys = keys != null ? keys : Collections.EMPTY_LIST;
        values = values != null ? values : Collections.EMPTY_LIST;
        return MapUtils.mapWithKeysAndValues(mapClass, keys.iterator(), values.iterator());
    }

    public static <K, V> Map<K, V> mapWithKeysAndValues(Class<? extends Map> mapClass, Iterator<K> keys, Iterator<V> values) {
        Map m = null;
        if (mapClass == null) {
            throw new IllegalArgumentException("Map class must not be null!");
        }
        try {
            m = mapClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (keys != null && values != null) {
            while (keys.hasNext() && values.hasNext()) {
                m.put(keys.next(), values.next());
            }
        }
        return m;
    }

    public static String toString(Map props, boolean newline) {
        int i;
        if (props == null || props.isEmpty()) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(props.size() * 32);
        buf.append('{');
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        Object[] entries = props.entrySet().toArray();
        for (i = 0; i < entries.length - 1; ++i) {
            Map.Entry property = (Map.Entry)entries[i];
            buf.append(property.getKey());
            buf.append('=');
            buf.append(PropertiesUtils.maskedPropertyValue(property));
            if (newline) {
                buf.append(SystemUtils.LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        Map.Entry lastProperty = (Map.Entry)entries[i];
        buf.append(lastProperty.getKey().toString());
        buf.append('=');
        buf.append(PropertiesUtils.maskedPropertyValue(lastProperty));
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append('}');
        return buf.toString();
    }
}

