/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.SerializationUtils;
import org.mule.util.store.DeserializationPostInitialisable;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Object result = src instanceof byte[] ? SerializationUtils.deserialize((byte[])src, this.muleContext.getExecutionClassLoader()) : SerializationUtils.deserialize((InputStream)src, this.muleContext.getExecutionClassLoader());
            if (result instanceof DeserializationPostInitialisable) {
                DeserializationPostInitialisable.Implementation.init(result, this.muleContext);
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

